/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.springframework.data.mongodb.core.query.Order;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class IndexField {
    private final String key;
    private final Order order;
    private final boolean isGeo;

    private IndexField(String key, Order order, boolean isGeo) {
        Assert.hasText((String)key);
        Assert.isTrue((boolean)(order != null ^ isGeo));
        this.key = key;
        this.order = order;
        this.isGeo = isGeo;
    }

    public static IndexField create(String key, Order order) {
        Assert.notNull((Object)((Object)order));
        return new IndexField(key, order, false);
    }

    public static IndexField geo(String key) {
        return new IndexField(key, null, true);
    }

    public String getKey() {
        return this.key;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isGeo() {
        return this.isGeo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexField)) {
            return false;
        }
        IndexField that = (IndexField)obj;
        return this.key.equals(that.key) && ObjectUtils.nullSafeEquals((Object)((Object)this.order), (Object)((Object)that.order)) && this.isGeo == that.isGeo;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.key);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)((Object)this.order));
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.isGeo);
    }

    public String toString() {
        return String.format("IndexField [ key: %s, order: %s, isGeo: %s]", new Object[]{this.key, this.order, this.isGeo});
    }
}

