/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.io.Serializable;
import java.util.Collection;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;

public abstract class QueryEngine<ADAPTER extends KeyValueAdapter, CRITERIA, SORT> {
    private final CriteriaAccessor<CRITERIA> criteriaAccessor;
    private final SortAccessor<SORT> sortAccessor;
    private ADAPTER adapter;

    public QueryEngine(CriteriaAccessor<CRITERIA> criteriaAccessor, SortAccessor<SORT> sortAccessor) {
        this.criteriaAccessor = criteriaAccessor;
        this.sortAccessor = sortAccessor;
    }

    public Collection<?> execute(KeyValueQuery<?> query, Serializable keyspace) {
        CRITERIA criteria = this.criteriaAccessor != null ? (CRITERIA)this.criteriaAccessor.resolve(query) : null;
        SORT sort = this.sortAccessor != null ? (SORT)this.sortAccessor.resolve(query) : null;
        return this.execute(criteria, sort, query.getOffset(), query.getRows(), keyspace);
    }

    public <T> Collection<T> execute(KeyValueQuery<?> query, Serializable keyspace, Class<T> type) {
        CRITERIA criteria = this.criteriaAccessor != null ? (CRITERIA)this.criteriaAccessor.resolve(query) : null;
        SORT sort = this.sortAccessor != null ? (SORT)this.sortAccessor.resolve(query) : null;
        return this.execute(criteria, sort, query.getOffset(), query.getRows(), keyspace, type);
    }

    public long count(KeyValueQuery<?> query, Serializable keyspace) {
        CRITERIA criteria = this.criteriaAccessor != null ? (CRITERIA)this.criteriaAccessor.resolve(query) : null;
        return this.count(criteria, keyspace);
    }

    public abstract Collection<?> execute(CRITERIA var1, SORT var2, int var3, int var4, Serializable var5);

    public <T> Collection<T> execute(CRITERIA criteria, SORT sort, int offset, int rows, Serializable keyspace, Class<T> type) {
        return this.execute(criteria, sort, offset, rows, keyspace);
    }

    public abstract long count(CRITERIA var1, Serializable var2);

    protected ADAPTER getAdapter() {
        return this.adapter;
    }

    public void registerAdapter(KeyValueAdapter adapter) {
        if (this.adapter != null) {
            throw new IllegalArgumentException("Cannot register more than one adapter for this QueryEngine.");
        }
        this.adapter = adapter;
    }
}

