/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class IterableConverter {
    private IterableConverter() {
    }

    public static <T> List<T> toList(Iterable<T> source) {
        if (source == null) {
            return Collections.emptyList();
        }
        if (source instanceof List) {
            return (List)source;
        }
        if (source instanceof Collection) {
            return new ArrayList((Collection)source);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T value : source) {
            result.add(value);
        }
        return result;
    }
}

