/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.SpelPropertyComparator;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.comparator.CompoundComparator;

class SpelSortAccessor
implements SortAccessor<Comparator<?>> {
    private final SpelExpressionParser parser;

    public SpelSortAccessor(SpelExpressionParser parser) {
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
        this.parser = parser;
    }

    @Override
    public Comparator<?> resolve(KeyValueQuery<?> query) {
        if (query == null || query.getSort() == null) {
            return null;
        }
        CompoundComparator compoundComperator = new CompoundComparator();
        for (Sort.Order order : query.getSort()) {
            SpelPropertyComparator spelSort = new SpelPropertyComparator(order.getProperty(), this.parser);
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                spelSort.desc();
                if (order.getNullHandling() != null && !Sort.NullHandling.NATIVE.equals((Object)order.getNullHandling())) {
                    spelSort = Sort.NullHandling.NULLS_FIRST.equals((Object)order.getNullHandling()) ? spelSort.nullsFirst() : spelSort.nullsLast();
                }
            }
            compoundComperator.addComparator(spelSort);
        }
        return compoundComperator;
    }
}

