/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

enum DefaultIdentifierGenerator implements IdentifierGenerator
{
    INSTANCE;

    private static final String ALGORITHM = "NativePRNGBlocking";

    @Override
    public <T> T generateIdentifierOfType(TypeInformation<T> identifierType) {
        Class type = identifierType.getType();
        if (ClassUtils.isAssignable(UUID.class, (Class)type)) {
            return (T)UUID.randomUUID();
        }
        if (ClassUtils.isAssignable(String.class, (Class)type)) {
            return (T)UUID.randomUUID().toString();
        }
        if (ClassUtils.isAssignable(Integer.class, (Class)type)) {
            try {
                return (T)SecureRandom.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidDataAccessApiUsageException("Could not create SecureRandom instance.", (Throwable)e);
            }
        }
        if (ClassUtils.isAssignable(Long.class, (Class)type)) {
            try {
                return (T)Long.valueOf(SecureRandom.getInstance(ALGORITHM).nextLong());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidDataAccessApiUsageException("Could not create SecureRandom instance.", (Throwable)e);
            }
        }
        throw new InvalidDataAccessApiUsageException("Non gereratable id type....");
    }
}

