/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

class ExpressionAwareParameterBinder
extends ParameterBinder {
    private final EvaluationContextProvider evaluationContextProvider;

    public ExpressionAwareParameterBinder(JpaParameters parameters, EvaluationContextProvider evaluationContextProvider) {
        this(parameters, new Object[0], evaluationContextProvider);
    }

    public ExpressionAwareParameterBinder(JpaParameters parameters, Object[] values, EvaluationContextProvider evaluationContextProvider) {
        super(parameters, values);
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        this.evaluationContextProvider = evaluationContextProvider;
    }

    protected Expression parseExpressionString(String expressionString) {
        return new SpelExpressionParser().parseExpression(expressionString);
    }

    protected Object evaluateExpression(String expressionString) {
        return this.evaluateExpression(this.parseExpressionString(expressionString));
    }

    protected Object evaluateExpression(Expression expr) {
        return expr.getValue(this.getEvaluationContext(), Object.class);
    }

    protected EvaluationContext getEvaluationContext() {
        return this.evaluationContextProvider.getEvaluationContext((Parameters)this.getParameters(), this.getValues());
    }
}

