/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.jdbc.core.JdbcIdentifierBuilder;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;
import org.springframework.util.Assert;

class DefaultJdbcInterpreter
implements Interpreter {
    private final RelationalMappingContext context;
    private final DataAccessStrategy accessStrategy;

    public <T> void interpret(DbAction.Insert<T> insert) {
        Object id = this.accessStrategy.insert(insert.getEntity(), insert.getEntityType(), this.getParentKeys((DbAction.WithDependingOn<?>)insert));
        insert.setGeneratedId(id);
    }

    public <T> void interpret(DbAction.InsertRoot<T> insert) {
        Object id = this.accessStrategy.insert(insert.getEntity(), insert.getEntityType(), Collections.emptyMap());
        insert.setGeneratedId(id);
    }

    public <T> void interpret(DbAction.Update<T> update) {
        this.accessStrategy.update(update.getEntity(), update.getEntityType());
    }

    public <T> void interpret(DbAction.UpdateRoot<T> update) {
        this.accessStrategy.update(update.getEntity(), update.getEntityType());
    }

    public <T> void interpret(DbAction.Merge<T> merge) {
        if (!this.accessStrategy.update(merge.getEntity(), merge.getEntityType())) {
            this.accessStrategy.insert(merge.getEntity(), merge.getEntityType(), this.getParentKeys((DbAction.WithDependingOn<?>)merge));
        }
    }

    public <T> void interpret(DbAction.Delete<T> delete) {
        this.accessStrategy.delete(delete.getRootId(), (PersistentPropertyPath<RelationalPersistentProperty>)delete.getPropertyPath());
    }

    public <T> void interpret(DbAction.DeleteRoot<T> delete) {
        this.accessStrategy.delete(delete.getRootId(), delete.getEntityType());
    }

    public <T> void interpret(DbAction.DeleteAll<T> delete) {
        this.accessStrategy.deleteAll((PersistentPropertyPath<RelationalPersistentProperty>)delete.getPropertyPath());
    }

    public <T> void interpret(DbAction.DeleteAllRoot<T> deleteAllRoot) {
        this.accessStrategy.deleteAll(deleteAllRoot.getEntityType());
    }

    private Identifier getParentKeys(DbAction.WithDependingOn<?> action) {
        Object id = this.getParentId(action);
        JdbcIdentifierBuilder identifier = JdbcIdentifierBuilder.forBackReferences(new PersistentPropertyPathExtension((MappingContext)this.context, action.getPropertyPath()), id);
        for (Map.Entry qualifier : action.getQualifiers().entrySet()) {
            identifier = identifier.withQualifier(new PersistentPropertyPathExtension((MappingContext)this.context, (PersistentPropertyPath)qualifier.getKey()), qualifier.getValue());
        }
        return identifier.build();
    }

    private Object getParentId(DbAction.WithDependingOn<?> action) {
        PersistentPropertyPathExtension path = new PersistentPropertyPathExtension((MappingContext)this.context, action.getPropertyPath());
        PersistentPropertyPathExtension idPath = path.getIdDefiningParentPath();
        DbAction.WithEntity idOwningAction = this.getIdOwningAction((DbAction.WithEntity)action, idPath);
        return this.getIdFrom(idOwningAction);
    }

    private DbAction.WithEntity getIdOwningAction(DbAction.WithEntity action, PersistentPropertyPathExtension idPath) {
        if (!(action instanceof DbAction.WithDependingOn)) {
            Assert.state((idPath.getLength() == 0 ? 1 : 0) != 0, (String)"When the id path is not empty the id providing action should be of type WithDependingOn");
            return action;
        }
        DbAction.WithDependingOn withDependingOn = (DbAction.WithDependingOn)action;
        if (idPath.matches(withDependingOn.getPropertyPath())) {
            return action;
        }
        return this.getIdOwningAction(withDependingOn.getDependingOn(), idPath);
    }

    private Object getIdFrom(DbAction.WithEntity idOwningAction) {
        Object generatedId;
        if (idOwningAction instanceof DbAction.WithGeneratedId && (generatedId = ((DbAction.WithGeneratedId)idOwningAction).getGeneratedId()) != null) {
            return generatedId;
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(idOwningAction.getEntityType());
        Object identifier = persistentEntity.getIdentifierAccessor(idOwningAction.getEntity()).getIdentifier();
        Assert.state((identifier != null ? 1 : 0) != 0, (String)"Couldn't get obtain a required id value");
        return identifier;
    }

    public DefaultJdbcInterpreter(RelationalMappingContext context, DataAccessStrategy accessStrategy) {
        this.context = context;
        this.accessStrategy = accessStrategy;
    }
}

