/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.AbstractImprovedSimpleBeanDefinitionParser;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractPropertiesConfiguredBeanDefinitionParser
extends AbstractImprovedSimpleBeanDefinitionParser {
    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"properties-ref".equals(attributeName) && !"properties-location".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        boolean hasProperties = false;
        BeanDefinitionBuilder b = BeanDefinitionBuilder.genericBeanDefinition(PropertiesFactoryBean.class);
        b.setScope(builder.getRawBeanDefinition().getScope());
        b.addPropertyValue("localOverride", (Object)true);
        ManagedList propsArray = new ManagedList(2);
        b.addPropertyValue("propertiesArray", (Object)propsArray);
        String attr = element.getAttribute("properties-ref");
        if (StringUtils.hasText((String)attr)) {
            hasProperties = true;
            propsArray.add((Object)new RuntimeBeanReference(attr));
        }
        hasProperties |= NamespaceUtils.setCSVProperty(element, b, "properties-location", "locations");
        attr = DomUtils.getTextValue((Element)element);
        if (StringUtils.hasText((String)attr)) {
            hasProperties = true;
            propsArray.add((Object)attr);
        }
        if (hasProperties) {
            b.setRole(2);
            builder.addPropertyValue("properties", (Object)b.getBeanDefinition());
        }
    }
}

