/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;

abstract class FetchableFluentQuerySupport<P, T>
implements FluentQuery.FetchableFluentQuery<T> {
    private final P predicate;
    private final Sort sort;
    private final Class<T> resultType;
    private final List<String> fieldsToInclude;

    FetchableFluentQuerySupport(P predicate, Sort sort, Class<T> resultType, List<String> fieldsToInclude) {
        this.predicate = predicate;
        this.sort = sort;
        this.resultType = resultType;
        this.fieldsToInclude = fieldsToInclude;
    }

    protected abstract <R> FetchableFluentQuerySupport<P, R> create(P var1, Sort var2, Class<R> var3, List<String> var4);

    public abstract T oneValue();

    public abstract T firstValue();

    public abstract List<T> all();

    public abstract Page<T> page(Pageable var1);

    public abstract Stream<T> stream();

    public abstract long count();

    public abstract boolean exists();

    P getPredicate() {
        return this.predicate;
    }

    Sort getSort() {
        return this.sort;
    }

    Class<T> getResultType() {
        return this.resultType;
    }

    List<String> getFieldsToInclude() {
        return this.fieldsToInclude;
    }
}

