/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class CouchbasePartTree
extends PartTree {
    private static final Pattern DISTINCT_TEMPLATE = Pattern.compile("^(find|read|get|query|search|stream|count)(Distinct)(\\p{Lu}.*?)(First|Top|By|$)");
    String[] distinctFields;

    public CouchbasePartTree(String methodName, Class<?> domainType) {
        super(methodName, domainType);
        this.maybeInitDistinctFields(methodName, domainType);
    }

    String[] getDistinctFields() {
        return this.distinctFields;
    }

    private void maybeInitDistinctFields(String methodName, Class<?> domainType) {
        if (this.isDistinct()) {
            Matcher grp = DISTINCT_TEMPLATE.matcher(methodName);
            if (grp.matches()) {
                String grp3 = grp.group(3);
                String[] names = grp.group(3).split("And");
                int parameterCount = names.length;
                this.distinctFields = new String[names.length];
                for (int i = 0; i < parameterCount; ++i) {
                    Part.Type type = Part.Type.fromProperty((String)names[i]);
                    PropertyPath path = PropertyPath.from((String)type.extractProperty(names[i]), domainType);
                    this.distinctFields[i] = path.toDotPath();
                }
            } else {
                this.distinctFields = new String[0];
            }
        }
    }
}

