/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQueryBase;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryExecution;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ResultProcessingConverter;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractReactiveCouchbaseQuery
extends AbstractCouchbaseQueryBase<ReactiveCouchbaseOperations>
implements RepositoryQuery {
    private final ReactiveFindByQueryOperation.ReactiveFindByQuery<?> findOp;
    private final ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<?> removeOp;

    public AbstractReactiveCouchbaseQuery(ReactiveCouchbaseQueryMethod method, ReactiveCouchbaseOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)((Object)method), (String)"CouchbaseQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ReactiveCouchbaseOperations must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getJavaType();
        this.findOp = (ReactiveFindByQueryOperation.ReactiveFindByQuery)operations.findByQuery(type).inScope(method.getScope()).inCollection(method.getCollection());
        this.removeOp = (ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery)operations.removeByQuery(type).inScope(method.getScope()).inCollection(method.getCollection());
    }

    @Override
    protected Object doExecute(CouchbaseQueryMethod method, ResultProcessor processor, ParametersParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        query = this.applyQueryMetaAttributesIfPresent(query, typeToRead);
        ReactiveCouchbaseQueryExecution execution = this.getExecution((ParameterAccessor)accessor, new ResultProcessingConverter<ReactiveCouchbaseOperations>(processor, (ReactiveCouchbaseOperations)this.getOperations(), this.getInstantiators()), this.findOp);
        return execution.execute(query, processor.getReturnedType().getDomainType(), typeToRead, method.getScope(), method.getCollection());
    }

    private ReactiveCouchbaseQueryExecution getExecution(ParameterAccessor accessor, Converter<Object, Object> resultProcessing, ReactiveFindByQueryOperation.ReactiveFindByQuery<?> operation) {
        return new ReactiveCouchbaseQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private ReactiveCouchbaseQueryExecution getExecutionToWrap(ParameterAccessor accessor, ReactiveFindByQueryOperation.ReactiveFindByQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new ReactiveCouchbaseQueryExecution.DeleteExecution(this.removeOp);
        }
        if (this.isTailable(this.getQueryMethod())) {
            return (q, t, r, s, c) -> operation.as(r).inScope(s).inCollection(c).matching(q.with(accessor.getPageable())).all();
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return (q, t, r, s, c) -> operation.as(r).inScope(s).inCollection(c).matching(q.with(accessor.getPageable())).all();
        }
        if (this.isCountQuery()) {
            return (q, t, r, s, c) -> operation.as(r).inScope(s).inCollection(c).matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, r, s, c) -> operation.as(r).inScope(s).inCollection(c).matching(q).exists();
        }
        return (q, t, r, s, c) -> {
            Object find = operation.as(r).inScope(s).inCollection(c).matching(q);
            return this.isLimiting() ? find.first() : find.one();
        };
    }
}

