/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperationSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.util.Assert;

public class ExecutableFindByQueryOperationSupport
implements ExecutableFindByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final CouchbaseTemplate template;

    public ExecutableFindByQueryOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByQueryOperation.ExecutableFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ExecutableFindByQuerySupport<T>(this.template, domainType, domainType, ALL_QUERY, null, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, null, null);
    }

    static class ExecutableFindByQuerySupport<T>
    implements ExecutableFindByQueryOperation.ExecutableFindByQuery<T> {
        private final CouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        private final ReactiveFindByQueryOperationSupport.ReactiveFindByQuerySupport<T> reactiveSupport;
        private final QueryScanConsistency scanConsistency;
        private final String scope;
        private final String collection;
        private final QueryOptions options;
        private final String[] distinctFields;
        private final String[] fields;

        ExecutableFindByQuerySupport(CouchbaseTemplate template, Class<?> domainType, Class<T> returnType, Query query, QueryScanConsistency scanConsistency, String scope, String collection, QueryOptions options, String[] distinctFields, String[] fields) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.reactiveSupport = new ReactiveFindByQueryOperationSupport.ReactiveFindByQuerySupport<T>(template.reactive(), domainType, returnType, query, scanConsistency, scope, collection, options, distinctFields, fields, new NonReactiveSupportWrapper(template.support()));
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.distinctFields = distinctFields;
            this.fields = fields;
        }

        @Override
        public T oneValue() {
            return (T)this.reactiveSupport.one().block();
        }

        @Override
        public T firstValue() {
            return (T)this.reactiveSupport.first().block();
        }

        @Override
        public List<T> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableFindByQueryOperation.TerminatingFindByQuery<T> matching(Query query) {
            QueryScanConsistency scanCons = query.getScanConsistency() != null ? query.getScanConsistency() : this.scanConsistency;
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, query, scanCons, this.scope, this.collection, this.options, this.distinctFields, this.fields);
        }

        @Override
        @Deprecated
        public ExecutableFindByQueryOperation.FindByQueryInScope<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.fields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.fields);
        }

        @Override
        public <R> ExecutableFindByQueryOperation.FindByQueryWithConsistency<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"returnType must not be null!");
            return new ExecutableFindByQuerySupport<R>(this.template, this.domainType, returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.fields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryWithProjection<T> project(String[] fields) {
            Assert.notNull((Object)fields, (String)"Fields must not be null");
            Assert.isNull((Object)this.distinctFields, (String)"only one of project(fields) and distinct(distinctFields) can be specified");
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, this.distinctFields, fields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryWithProjection<T> distinct(String[] distinctFields) {
            Assert.notNull((Object)distinctFields, (String)"distinctFields must not be null");
            Assert.isNull((Object)this.fields, (String)"only one of project(fields) and distinct(distinctFields) can be specified");
            String[] dFields = distinctFields.length == 1 && "-".equals(distinctFields[0]) ? null : distinctFields;
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, dFields, this.fields);
        }

        @Override
        public Stream<T> stream() {
            return this.reactiveSupport.all().toStream();
        }

        @Override
        public long count() {
            Long l = (Long)this.reactiveSupport.count().block();
            if (l == null) {
                throw new CouchbaseQueryExecutionException("count query did not return a count : " + this.query.export(new int[0][]));
            }
            return l;
        }

        @Override
        public boolean exists() {
            return this.count() > 0L;
        }

        @Override
        public ExecutableFindByQueryOperation.TerminatingFindByQuery<T> withOptions(QueryOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, options, this.distinctFields, this.fields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryInCollection<T> inScope(String scope) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, scope != null ? scope : this.scope, this.collection, this.options, this.distinctFields, this.fields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryWithConsistency<T> inCollection(String collection) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, collection != null ? collection : this.collection, this.options, this.distinctFields, this.fields);
        }
    }
}

