/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseBucket;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;

public class CouchbaseBucketFactoryBean
extends AbstractFactoryBean<Bucket>
implements PersistenceExceptionTranslator {
    private final Cluster cluster;
    private final String bucketName;
    private final String username;
    private final String password;
    private final PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();

    public CouchbaseBucketFactoryBean(Cluster cluster) {
        this(cluster, null, null, null);
    }

    public CouchbaseBucketFactoryBean(Cluster cluster, String bucketName) {
        this(cluster, bucketName, bucketName, null);
    }

    public CouchbaseBucketFactoryBean(Cluster cluster, String bucketName, String username, String password) {
        this.cluster = cluster;
        this.bucketName = bucketName;
        this.username = username;
        this.password = password;
    }

    public Class<?> getObjectType() {
        return CouchbaseBucket.class;
    }

    protected Bucket createInstance() throws Exception {
        if (this.bucketName == null) {
            return this.cluster.openBucket();
        }
        if (this.password == null) {
            return this.cluster.openBucket(this.bucketName);
        }
        if (this.bucketName.contentEquals(this.username)) {
            return this.cluster.openBucket(this.bucketName, this.password);
        }
        this.cluster.authenticate(this.username, this.password);
        return this.cluster.openBucket(this.bucketName);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }
}

