/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Statement;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveAbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ReactiveStringN1qlBasedQuery
extends ReactiveAbstractN1qlBasedQuery {
    private final StringBasedN1qlQueryParser queryParser;
    private final SpelExpressionParser parser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    protected String getTypeField() {
        return this.getCouchbaseOperations().getConverter().getTypeKey();
    }

    protected Class<?> getTypeValue() {
        return this.getQueryMethod().getEntityInformation().getJavaType();
    }

    public ReactiveStringN1qlBasedQuery(String statement, CouchbaseQueryMethod queryMethod, RxJavaCouchbaseOperations couchbaseOperations, SpelExpressionParser spelParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, couchbaseOperations);
        this.queryParser = new StringBasedN1qlQueryParser(statement, queryMethod, this.getCouchbaseOperations().getCouchbaseBucket().name(), this.getCouchbaseOperations().getConverter(), this.getTypeField(), this.getTypeValue());
        this.parser = spelParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.queryParser.getPlaceholderValues(accessor);
    }

    @Override
    public Statement getStatement(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        String parsedStatement = this.queryParser.doParse(this.parser, evaluationContext, false);
        return N1qlQuery.simple((String)parsedStatement).statement();
    }
}

