/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert.translation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class JacksonTranslationService
implements TranslationService,
InitializingBean {
    private ObjectMapper objectMapper;
    private SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder();
    private JsonFactory factory = new JsonFactory();

    @Override
    public final String encode(CouchbaseStorable source) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = this.factory.createGenerator((Writer)writer);
            this.encodeRecursive(source, generator);
            generator.close();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not encode JSON", ex);
        }
        return ((Object)writer).toString();
    }

    private void encodeRecursive(CouchbaseStorable source, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : ((CouchbaseDocument)source).export().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            generator.writeFieldName(key);
            if (value instanceof CouchbaseDocument) {
                this.encodeRecursive((CouchbaseDocument)value, generator);
                continue;
            }
            Class<?> clazz = value.getClass();
            if (this.simpleTypeHolder.isSimpleType(clazz) && !this.isEnumOrClass(clazz)) {
                generator.writeObject(value);
                continue;
            }
            this.objectMapper.writeValue(generator, value);
        }
        generator.writeEndObject();
    }

    private boolean isEnumOrClass(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz) || Class.class.isAssignableFrom(clazz);
    }

    @Override
    public final CouchbaseStorable decode(String source, CouchbaseStorable target) {
        try {
            JsonParser parser = this.factory.createParser(source);
            if (parser.nextToken() != null) {
                JsonToken currentToken = parser.getCurrentToken();
                if (currentToken == JsonToken.START_OBJECT) {
                    return this.decodeObject(parser, (CouchbaseDocument)target);
                }
                if (currentToken == JsonToken.START_ARRAY) {
                    return this.decodeArray(parser, new CouchbaseList());
                }
                throw new MappingException("JSON to decode needs to start as array or object!");
            }
            parser.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not decode JSON", ex);
        }
        return target;
    }

    private CouchbaseDocument decodeObject(JsonParser parser, CouchbaseDocument target) throws IOException {
        JsonToken currentToken = parser.nextToken();
        String fieldName = "";
        while (currentToken != null && currentToken != JsonToken.END_OBJECT) {
            if (currentToken == JsonToken.START_OBJECT) {
                target.put(fieldName, this.decodeObject(parser, new CouchbaseDocument()));
            } else if (currentToken == JsonToken.START_ARRAY) {
                target.put(fieldName, this.decodeArray(parser, new CouchbaseList()));
            } else if (currentToken == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
            } else {
                target.put(fieldName, this.decodePrimitive(currentToken, parser));
            }
            currentToken = parser.nextToken();
        }
        return target;
    }

    private CouchbaseList decodeArray(JsonParser parser, CouchbaseList target) throws IOException {
        JsonToken currentToken = parser.nextToken();
        while (currentToken != null && currentToken != JsonToken.END_ARRAY) {
            if (currentToken == JsonToken.START_OBJECT) {
                target.put(this.decodeObject(parser, new CouchbaseDocument()));
            } else if (currentToken == JsonToken.START_ARRAY) {
                target.put(this.decodeArray(parser, new CouchbaseList()));
            } else {
                target.put(this.decodePrimitive(currentToken, parser));
            }
            currentToken = parser.nextToken();
        }
        return target;
    }

    private Object decodePrimitive(JsonToken token, JsonParser parser) throws IOException {
        switch (token) {
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return parser.getBooleanValue();
            }
            case VALUE_STRING: {
                return parser.getValueAsString();
            }
            case VALUE_NUMBER_INT: {
                return parser.getNumberValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return parser.getDoubleValue();
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new MappingException("Could not decode primitive value " + token);
    }

    @Override
    public <T> T decodeFragment(String source, Class<T> target) {
        try {
            return (T)this.objectMapper.readValue(source, target);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot decode ad-hoc JSON", e);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void afterPropertiesSet() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
    }
}

