/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnRibbonZookeeper;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesPassed;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@ConditionalOnRibbonZookeeper
@ConditionalOnDependenciesPassed
@AutoConfigureBefore(value={RibbonAutoConfiguration.class})
public class DependencyRibbonAutoConfiguration {
    private static final Log log = LogFactory.getLog(DependencyRibbonAutoConfiguration.class);
    @Autowired
    ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.zookeeper.dependency.ribbon.enabled"}, matchIfMissing=true)
    public LoadBalancerClient loadBalancerClient(SpringClientFactory springClientFactory) {
        return new RibbonLoadBalancerClient(springClientFactory){

            protected Server getServer(String serviceId) {
                ILoadBalancer loadBalancer = this.getLoadBalancer(serviceId);
                return loadBalancer == null ? null : this.chooseServerByServiceIdOrDefault(loadBalancer, serviceId);
            }

            private Server chooseServerByServiceIdOrDefault(ILoadBalancer loadBalancer, String serviceId) {
                log.debug((Object)String.format("Dependencies are set - will try to load balance via provided load balancer [%s] for key [%s]", loadBalancer, serviceId));
                Server server = loadBalancer.chooseServer((Object)serviceId);
                log.debug((Object)String.format("Retrieved server [%s] via load balancer", server));
                return server != null ? server : loadBalancer.chooseServer((Object)"default");
            }
        };
    }
}

