/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnRibbonZookeeper;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesPassed;
import org.springframework.cloud.zookeeper.discovery.dependency.DependencyRibbonAutoConfiguration;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependency;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@ConditionalOnRibbonZookeeper
@ConditionalOnDependenciesPassed
@ConditionalOnProperty(value={"spring.cloud.zookeeper.dependency.resttemplate.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DependencyRibbonAutoConfiguration.class})
public class DependencyRestTemplateAutoConfiguration {
    @Autowired
    @LoadBalanced
    RestTemplate restTemplate;
    @Autowired
    ZookeeperDependencies zookeeperDependencies;

    @PostConstruct
    void customizeRestTemplate() {
        this.restTemplate.getInterceptors().add(new ClientHttpRequestInterceptor(){

            public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                String clientName = request.getURI().getHost();
                ZookeeperDependency dependencyForAlias = DependencyRestTemplateAutoConfiguration.this.zookeeperDependencies.getDependencyForAlias(clientName);
                HttpHeaders headers = this.getUpdatedHeadersIfPossible(request, dependencyForAlias);
                request.getHeaders().putAll((Map)headers);
                return execution.execute(request, body);
            }

            private HttpHeaders getUpdatedHeadersIfPossible(HttpRequest request, ZookeeperDependency dependencyForAlias) {
                HttpHeaders httpHeaders = new HttpHeaders();
                if (dependencyForAlias != null) {
                    Map<String, Collection<String>> updatedHeaders = dependencyForAlias.getUpdatedHeaders(this.convertHeadersFromListToCollection(request.getHeaders()));
                    httpHeaders.putAll(this.convertHeadersFromCollectionToList(updatedHeaders));
                    return httpHeaders;
                }
                httpHeaders.putAll((Map)request.getHeaders());
                return httpHeaders;
            }

            private Map<String, Collection<String>> convertHeadersFromListToCollection(HttpHeaders headers) {
                HashMap<String, Collection<String>> transformedHeaders = new HashMap<String, Collection<String>>();
                for (Map.Entry entry : headers.entrySet()) {
                    transformedHeaders.put((String)entry.getKey(), (Collection<String>)entry.getValue());
                }
                return transformedHeaders;
            }

            private Map<String, List<String>> convertHeadersFromCollectionToList(Map<String, Collection<String>> headers) {
                HashMap<String, List<String>> transformedHeaders = new HashMap<String, List<String>>();
                for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
                    transformedHeaders.put(entry.getKey(), new ArrayList<String>(entry.getValue()));
                }
                return transformedHeaders;
            }
        });
    }
}

