/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import java.net.URI;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import zipkin.Component;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoding;
import zipkin.reporter.Sender;

final class RestTemplateSender
implements Sender {
    final RestTemplate restTemplate;
    final String url;
    transient boolean closeCalled;

    RestTemplateSender(RestTemplate restTemplate, String baseUrl) {
        this.restTemplate = restTemplate;
        this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans";
    }

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> spans) {
        return this.encoding().listSizeInBytes(spans);
    }

    public void sendSpans(List<byte[]> encodedSpans, Callback callback) {
        block3: {
            if (this.closeCalled) {
                throw new IllegalStateException("close");
            }
            try {
                byte[] message = BytesMessageEncoder.JSON.encode(encodedSpans);
                this.post(message);
                callback.onComplete();
            }
            catch (Throwable e) {
                callback.onError(e);
                if (!(e instanceof Error)) break block3;
                throw (Error)e;
            }
        }
    }

    public Component.CheckResult check() {
        try {
            this.post(new byte[]{91, 93});
            return Component.CheckResult.OK;
        }
        catch (Exception e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    void post(byte[] json) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        RequestEntity requestEntity = new RequestEntity((Object)json, (MultiValueMap)httpHeaders, HttpMethod.POST, URI.create(this.url));
        this.restTemplate.exchange(requestEntity, String.class);
    }
}

