/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.messaging;

import brave.Tracer;
import brave.Tracing;
import brave.jms.JmsTracing;
import brave.kafka.clients.KafkaTracing;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.messaging.MessagingTracingCustomizer;
import brave.sampler.SamplerFunction;
import brave.spring.rabbit.SpringRabbitTracing;
import java.util.List;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.brave.instrument.messaging.ConditionalOnMessagingEnabled;
import org.springframework.cloud.sleuth.brave.instrument.messaging.ConsumerSampler;
import org.springframework.cloud.sleuth.brave.instrument.messaging.KafkaFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.brave.instrument.messaging.ProducerSampler;
import org.springframework.cloud.sleuth.brave.instrument.messaging.SleuthKafkaAspect;
import org.springframework.cloud.sleuth.brave.instrument.messaging.SleuthRabbitBeanPostProcessor;
import org.springframework.cloud.sleuth.brave.instrument.messaging.TracingConnectionFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.brave.instrument.messaging.TracingJmsBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MessagingTracing.class})
@ConditionalOnMessagingEnabled
@ConditionalOnBean(value={Tracing.class})
@EnableConfigurationProperties(value={SleuthMessagingProperties.class})
public class BraveMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessagingTracing messagingTracing(Tracing tracing, @Nullable @ProducerSampler SamplerFunction<MessagingRequest> producerSampler, @Nullable @ConsumerSampler SamplerFunction<MessagingRequest> consumerSampler, @Nullable List<MessagingTracingCustomizer> messagingTracingCustomizers) {
        MessagingTracing.Builder builder = MessagingTracing.newBuilder((Tracing)tracing);
        if (producerSampler != null) {
            builder.producerSampler(producerSampler);
        }
        if (consumerSampler != null) {
            builder.consumerSampler(consumerSampler);
        }
        if (messagingTracingCustomizers != null) {
            for (MessagingTracingCustomizer customizer : messagingTracingCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.jms.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={JmsListenerConfigurer.class})
    @ConditionalOnBean(value={JmsListenerEndpointRegistry.class})
    @Role(value=2)
    protected static class SleuthJmsConfiguration {
        protected SleuthJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JmsTracing jmsTracing(MessagingTracing messagingTracing, SleuthMessagingProperties properties) {
            return JmsTracing.newBuilder((MessagingTracing)messagingTracing).remoteServiceName(properties.getJms().getRemoteServiceName()).build();
        }

        @Bean
        @ConditionalOnMissingBean
        TracingConnectionFactoryBeanPostProcessor tracingConnectionFactoryBeanPostProcessor(BeanFactory beanFactory) {
            return new TracingConnectionFactoryBeanPostProcessor(beanFactory);
        }

        @Bean
        JmsListenerConfigurer configureTracing(BeanFactory beanFactory, JmsListenerEndpointRegistry defaultRegistry) {
            return registrar -> {
                TracingJmsBeanPostProcessor processor = (TracingJmsBeanPostProcessor)beanFactory.getBean(TracingJmsBeanPostProcessor.class);
                JmsListenerEndpointRegistry registry = registrar.getEndpointRegistry();
                registrar.setEndpointRegistry((JmsListenerEndpointRegistry)processor.postProcessAfterInitialization((Object)(registry == null ? defaultRegistry : registry), ""));
            };
        }

        @Bean
        static TracingJmsBeanPostProcessor tracingJmsBeanPostProcessor(BeanFactory beanFactory) {
            return new TracingJmsBeanPostProcessor(beanFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.kafka.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={KafkaTracing.class, ProducerFactory.class})
    protected static class SleuthKafkaConfiguration {
        protected SleuthKafkaConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        KafkaTracing kafkaTracing(MessagingTracing messagingTracing, SleuthMessagingProperties properties) {
            return KafkaTracing.newBuilder((MessagingTracing)messagingTracing).remoteServiceName(properties.getKafka().getRemoteServiceName()).build();
        }

        @Bean
        @ConditionalOnMissingBean
        SleuthKafkaAspect sleuthKafkaAspect(KafkaTracing kafkaTracing, Tracer tracer) {
            return new SleuthKafkaAspect(kafkaTracing, tracer);
        }

        @Bean
        static KafkaFactoryBeanPostProcessor kafkaFactoryBeanPostProcessor(BeanFactory beanFactory) {
            return new KafkaFactoryBeanPostProcessor(beanFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.rabbit.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={RabbitTemplate.class})
    protected static class SleuthRabbitConfiguration {
        protected SleuthRabbitConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        static SleuthRabbitBeanPostProcessor sleuthRabbitBeanPostProcessor(BeanFactory beanFactory) {
            return new SleuthRabbitBeanPostProcessor(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        SpringRabbitTracing springRabbitTracing(MessagingTracing messagingTracing, SleuthMessagingProperties properties) {
            return SpringRabbitTracing.newBuilder((MessagingTracing)messagingTracing).remoteServiceName(properties.getRabbit().getRemoteServiceName()).build();
        }
    }
}

