/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.config.EurekaConfigServerInstanceProvider;
import org.springframework.cloud.netflix.eureka.config.HostnameBasedUrlRandomizer;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactory;
import org.springframework.util.ClassUtils;

public class EurekaConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null)) {
            return;
        }
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, EurekaFunction::create);
    }

    private static Boolean getDiscoveryEnabled(Binder binder) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Boolean.class).orElse((Object)false) != false && (Boolean)binder.bind("eureka.client.enabled", Boolean.class).orElse((Object)true) != false && (Boolean)binder.bind("spring.cloud.discovery.enabled", Boolean.class).orElse((Object)true) != false;
    }

    static final class EurekaFunction
    implements ConfigServerInstanceProvider.Function {
        private final BootstrapContext context;

        static EurekaFunction create(BootstrapContext context) {
            return new EurekaFunction(context);
        }

        private EurekaFunction(BootstrapContext context) {
            this.context = context;
        }

        public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            if (binder == null || !EurekaConfigServerBootstrapper.getDiscoveryEnabled(binder).booleanValue()) {
                return Collections.emptyList();
            }
            EurekaClientConfigBean config = (EurekaClientConfigBean)binder.bind("eureka.client", EurekaClientConfigBean.class).orElseGet(EurekaClientConfigBean::new);
            EurekaHttpClient httpClient = new RestTemplateTransportClientFactory((TlsProperties)this.context.getOrElse(TlsProperties.class, null), (EurekaClientHttpRequestFactorySupplier)this.context.getOrElse(EurekaClientHttpRequestFactorySupplier.class, (Object)new DefaultEurekaClientHttpRequestFactorySupplier())).newClient((EurekaEndpoint)HostnameBasedUrlRandomizer.randomEndpoint((EurekaClientConfig)config, binder));
            return new EurekaConfigServerInstanceProvider(httpClient, config).getInstances(serviceId);
        }

        public List<ServiceInstance> apply(String serviceId) {
            return this.apply(serviceId, null, null, null);
        }
    }
}

