/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.Bootstrapper;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.config.EurekaConfigServerInstanceProvider;
import org.springframework.cloud.netflix.eureka.config.HostnameBasedUrlRandomizer;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactory;
import org.springframework.util.ClassUtils;

public class EurekaConfigServerBootstrapper
implements Bootstrapper {
    public void intitialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null)) {
            return;
        }
        registry.registerIfAbsent(EurekaClientConfigBean.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.getDiscoveryEnabled(binder).booleanValue()) {
                return null;
            }
            return (EurekaClientConfigBean)binder.bind("eureka.client", EurekaClientConfigBean.class).orElseGet(EurekaClientConfigBean::new);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.getDiscoveryEnabled(binder).booleanValue()) {
                return null;
            }
            EurekaClientConfigBean config = (EurekaClientConfigBean)context.get(EurekaClientConfigBean.class);
            EurekaHttpClient httpClient = new RestTemplateTransportClientFactory().newClient((EurekaEndpoint)HostnameBasedUrlRandomizer.randomEndpoint(config, binder));
            return new EurekaConfigServerInstanceProvider(httpClient, config)::getInstances;
        });
    }

    private Boolean getDiscoveryEnabled(Binder binder) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Boolean.class).orElse((Object)false);
    }
}

