/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class EurekaHealthCheckHandler
implements HealthCheckHandler,
ApplicationContextAware,
InitializingBean {
    private static final Map<Status, InstanceInfo.InstanceStatus> STATUS_MAPPING = new HashMap<Status, InstanceInfo.InstanceStatus>(){
        {
            this.put(Status.UNKNOWN, InstanceInfo.InstanceStatus.UNKNOWN);
            this.put(Status.OUT_OF_SERVICE, InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
            this.put(Status.DOWN, InstanceInfo.InstanceStatus.DOWN);
            this.put(Status.UP, InstanceInfo.InstanceStatus.UP);
        }
    };
    private StatusAggregator statusAggregator;
    private ApplicationContext applicationContext;
    private Map<String, HealthIndicator> healthIndicators = new HashMap<String, HealthIndicator>();
    private Map<String, ReactiveHealthIndicator> reactiveHealthIndicators = new HashMap<String, ReactiveHealthIndicator>();

    public EurekaHealthCheckHandler(StatusAggregator statusAggregator) {
        this.statusAggregator = statusAggregator;
        Assert.notNull((Object)statusAggregator, (String)"StatusAggregator must not be null");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Map healthIndicators = this.applicationContext.getBeansOfType(HealthIndicator.class);
        Map reactiveHealthIndicators = this.applicationContext.getBeansOfType(ReactiveHealthIndicator.class);
        this.populateHealthIndicators(healthIndicators);
        this.populateReactiveHealthIndicators(reactiveHealthIndicators);
    }

    void populateHealthIndicators(Map<String, HealthIndicator> healthIndicators) {
        for (Map.Entry<String, HealthIndicator> entry : healthIndicators.entrySet()) {
            if (entry.getValue() instanceof DiscoveryCompositeHealthContributor) {
                DiscoveryCompositeHealthContributor indicator = (DiscoveryCompositeHealthContributor)entry.getValue();
                indicator.forEach(contributor -> {
                    if (!(contributor.getContributor() instanceof EurekaHealthIndicator)) {
                        this.healthIndicators.put(contributor.getName(), (HealthIndicator)contributor.getContributor());
                    }
                });
                continue;
            }
            this.healthIndicators.put(entry.getKey(), entry.getValue());
        }
    }

    void populateReactiveHealthIndicators(Map<String, ReactiveHealthIndicator> reactiveHealthIndicators) {
        for (Map.Entry<String, ReactiveHealthIndicator> entry : reactiveHealthIndicators.entrySet()) {
            this.reactiveHealthIndicators.put(entry.getKey(), entry.getValue());
        }
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus instanceStatus) {
        return this.getHealthStatus();
    }

    protected InstanceInfo.InstanceStatus getHealthStatus() {
        Status status = this.getStatus(this.statusAggregator);
        return this.mapToInstanceStatus(status);
    }

    protected Status getStatus(StatusAggregator statusAggregator) {
        HashSet statusSet = new HashSet();
        if (this.healthIndicators != null) {
            statusSet.addAll(this.healthIndicators.values().stream().map(HealthIndicator::health).map(Health::getStatus).collect(Collectors.toSet()));
        }
        if (this.reactiveHealthIndicators != null) {
            statusSet.addAll(this.reactiveHealthIndicators.values().stream().map(ReactiveHealthIndicator::health).map(Mono::block).filter(Objects::nonNull).map(Health::getStatus).collect(Collectors.toSet()));
        }
        Status status = statusAggregator.getAggregateStatus(statusSet);
        return status;
    }

    protected InstanceInfo.InstanceStatus mapToInstanceStatus(Status status) {
        if (!STATUS_MAPPING.containsKey(status)) {
            return InstanceInfo.InstanceStatus.UNKNOWN;
        }
        return STATUS_MAPPING.get(status);
    }
}

