/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.gateway")
@Validated
public class GatewayProperties {
    public static final String PREFIX = "spring.cloud.gateway";
    private final Log logger = LogFactory.getLog(this.getClass());
    @NotNull
    @Valid
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    private List<FilterDefinition> defaultFilters = new ArrayList<FilterDefinition>();
    private List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, MediaType.APPLICATION_STREAM_JSON);
    private boolean failOnRouteDefinitionError = true;
    private Metrics metrics = new Metrics();

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
        if (routes != null && routes.size() > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Routes supplied from Gateway Properties: " + routes));
        }
    }

    public List<FilterDefinition> getDefaultFilters() {
        return this.defaultFilters;
    }

    public void setDefaultFilters(List<FilterDefinition> defaultFilters) {
        this.defaultFilters = defaultFilters;
    }

    public List<MediaType> getStreamingMediaTypes() {
        return this.streamingMediaTypes;
    }

    public void setStreamingMediaTypes(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    public boolean isFailOnRouteDefinitionError() {
        return this.failOnRouteDefinitionError;
    }

    public void setFailOnRouteDefinitionError(boolean failOnRouteDefinitionError) {
        this.failOnRouteDefinitionError = failOnRouteDefinitionError;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("routes", this.routes).append("defaultFilters", this.defaultFilters).append("streamingMediaTypes", this.streamingMediaTypes).append("failOnRouteDefinitionError", this.failOnRouteDefinitionError).append("metrics", (Object)this.metrics).toString();
    }

    public static class Metrics {
        public static final String DEFAULT_PREFIX = "gateway";
        private boolean enabled;
        private String prefix = "gateway";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("enabled", this.enabled).append("prefix", (Object)this.prefix).toString();
        }
    }
}

