/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteSizeUtils {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(?<amount>\\d+)(?<unit>(m|g)?)", 2);

    private ByteSizeUtils() {
    }

    public static long parseToMebibytes(String text) {
        Matcher matcher = SIZE_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Could not parse '%s' as a byte size. Expected a number with optional 'm' or 'g' suffix", text));
        }
        long size = Long.parseLong(matcher.group("amount"));
        if (matcher.group("unit").equalsIgnoreCase("g")) {
            size *= 1024L;
        }
        return size;
    }
}

