/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.util.StringUtils;

abstract class AbstractCipherResourceEncryptor
implements ResourceEncryptor {
    protected final String CIPHER_MARKER = "{cipher}";
    private final TextEncryptorLocator encryptor;
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();

    AbstractCipherResourceEncryptor(TextEncryptorLocator encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public abstract List<String> getSupportedExtensions();

    @Override
    public abstract String decrypt(String var1, Environment var2) throws IOException;

    protected String decryptWithJacksonParser(String text, String name, String[] profiles, JsonFactory factory) throws IOException {
        JsonToken token;
        HashSet<String> valsToDecrpyt = new HashSet<String>();
        JsonParser parser = factory.createParser(text);
        while ((token = parser.nextToken()) != null) {
            if (!token.equals((Object)JsonToken.VALUE_STRING) || !parser.getValueAsString().startsWith("{cipher}")) continue;
            valsToDecrpyt.add(parser.getValueAsString().trim());
        }
        for (String value : valsToDecrpyt) {
            String decryptedValue = this.decryptValue(value.replace("{cipher}", ""), name, profiles);
            text = text.replace(value, decryptedValue);
        }
        return text;
    }

    protected String decryptValue(String value, String name, String[] profiles) {
        return this.encryptor.locate(this.helper.getEncryptorKeys(name, StringUtils.arrayToCommaDelimitedString((Object[])profiles), value)).decrypt(this.helper.stripPrefix(value));
    }
}

