/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.composite;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cloud.config.server.composite.CompositeUtils;
import org.springframework.cloud.config.server.composite.ConditionalOnMissingSearchPathLocator;
import org.springframework.cloud.config.server.composite.ConditionalOnSearchPathLocator;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnSearchPathLocatorPresent
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        List<String> types = CompositeUtils.getCompositeTypeList(context.getEnvironment());
        ArrayList<Class> repositoryTypes = new ArrayList<Class>();
        for (String type : types) {
            String factoryName = CompositeUtils.getFactoryName(type, beanFactory);
            Type[] actualTypeArguments = CompositeUtils.getEnvironmentRepositoryFactoryTypeParams(beanFactory, factoryName);
            Class repositoryType = (Class)actualTypeArguments[0];
            repositoryTypes.add(repositoryType);
        }
        boolean required = metadata.isAnnotated(ConditionalOnSearchPathLocator.class.getName());
        boolean foundSearchPathLocator = repositoryTypes.stream().anyMatch(SearchPathLocator.class::isAssignableFrom);
        if (required && !foundSearchPathLocator) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnSearchPathLocator.class, (Object[])new Object[0]).notAvailable(SearchPathLocator.class.getTypeName()));
        }
        if (!required && foundSearchPathLocator) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnMissingSearchPathLocator.class, (Object[])new Object[0]).available(SearchPathLocator.class.getTypeName()));
        }
        return ConditionOutcome.match();
    }
}

