/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.style.ToStringCreator;

public interface SslOptions {
    public static final SslOptions NONE = SslOptions.of(null, (Set<String>)null);

    default public boolean isSpecified() {
        return this.getCiphers() != null || this.getEnabledProtocols() != null;
    }

    public String @Nullable [] getCiphers();

    public String @Nullable [] getEnabledProtocols();

    public static SslOptions of(final String @Nullable [] ciphers, final String @Nullable [] enabledProtocols) {
        return new SslOptions(){

            @Override
            public String @Nullable [] getCiphers() {
                return ciphers;
            }

            @Override
            public String @Nullable [] getEnabledProtocols() {
                return enabledProtocols;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator((Object)this);
                creator.append("ciphers", (Object)ciphers);
                creator.append("enabledProtocols", (Object)enabledProtocols);
                return creator.toString();
            }
        };
    }

    public static SslOptions of(@Nullable Set<String> ciphers, @Nullable Set<String> enabledProtocols) {
        return SslOptions.of(SslOptions.toArray(ciphers), SslOptions.toArray(enabledProtocols));
    }

    public static @Nullable Set<String> asSet(String @Nullable [] array) {
        return array != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(array))) : null;
    }

    private static String @Nullable [] toArray(@Nullable Collection<String> collection) {
        return collection != null ? (String[])collection.toArray(String[]::new) : null;
    }
}

