/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.sql.Wrapper;
import javax.sql.DataSource;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.ClassUtils;

public final class DataSourceUnwrapper {
    private static final boolean DELEGATING_DATA_SOURCE_PRESENT = ClassUtils.isPresent((String)"org.springframework.jdbc.datasource.DelegatingDataSource", (ClassLoader)DataSourceUnwrapper.class.getClassLoader());

    private DataSourceUnwrapper() {
    }

    public static <T> T unwrap(DataSource dataSource, Class<T> target) {
        Object proxyTarget;
        DataSource targetDataSource;
        if (target.isInstance(dataSource)) {
            return target.cast(dataSource);
        }
        T unwrapped = DataSourceUnwrapper.safeUnwrap(dataSource, target);
        if (unwrapped != null) {
            return unwrapped;
        }
        if (DELEGATING_DATA_SOURCE_PRESENT && (targetDataSource = DelegatingDataSourceUnwrapper.getTargetDataSource(dataSource)) != null) {
            return DataSourceUnwrapper.unwrap(targetDataSource, target);
        }
        if (AopUtils.isAopProxy((Object)dataSource) && (proxyTarget = AopProxyUtils.getSingletonTarget((Object)dataSource)) instanceof DataSource) {
            return DataSourceUnwrapper.unwrap((DataSource)proxyTarget, target);
        }
        return null;
    }

    private static <S> S safeUnwrap(Wrapper wrapper, Class<S> target) {
        try {
            return wrapper.unwrap(target);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static class DelegatingDataSourceUnwrapper {
        private DelegatingDataSourceUnwrapper() {
        }

        private static DataSource getTargetDataSource(DataSource dataSource) {
            if (dataSource instanceof DelegatingDataSource) {
                return ((DelegatingDataSource)dataSource).getTargetDataSource();
            }
            return null;
        }
    }
}

