/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet.context;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebServlet;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.server.servlet.context.ServletComponentHandler;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class WebServletHandler
extends ServletComponentHandler {
    WebServletHandler() {
        super(WebServlet.class);
    }

    @Override
    public void doHandle(Map<String, @Nullable Object> attributes, AnnotatedBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServletRegistrationBean.class);
        builder.addPropertyValue("asyncSupported", attributes.get("asyncSupported"));
        builder.addPropertyValue("initParameters", this.extractInitParameters(attributes));
        builder.addPropertyValue("loadOnStartup", attributes.get("loadOnStartup"));
        String name = this.determineName(attributes, (BeanDefinition)beanDefinition);
        builder.addPropertyValue("name", (Object)name);
        builder.addPropertyValue("servlet", (Object)beanDefinition);
        builder.addPropertyValue("urlMappings", (Object)this.extractUrlPatterns(attributes));
        builder.addPropertyValue("multipartConfig", (Object)this.determineMultipartConfig(beanDefinition));
        registry.registerBeanDefinition(name, (BeanDefinition)builder.getBeanDefinition());
    }

    private String determineName(Map<String, @Nullable Object> attributes, BeanDefinition beanDefinition) {
        String name = (String)attributes.get("name");
        return StringUtils.hasText((String)name) ? name : this.getBeanClassName(beanDefinition);
    }

    private String getBeanClassName(BeanDefinition beanDefinition) {
        String name = beanDefinition.getBeanClassName();
        Assert.state((name != null ? 1 : 0) != 0, (String)"'name' must not be null");
        return name;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable BeanDefinition determineMultipartConfig(AnnotatedBeanDefinition beanDefinition) {
        @Nullable Map attributes = beanDefinition.getMetadata().getAnnotationAttributes(MultipartConfig.class.getName());
        if (attributes == null) {
            return null;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(MultipartConfigElement.class);
        builder.addConstructorArgValue(attributes.get("location"));
        builder.addConstructorArgValue(attributes.get("maxFileSize"));
        builder.addConstructorArgValue(attributes.get("maxRequestSize"));
        builder.addConstructorArgValue(attributes.get("fileSizeThreshold"));
        return builder.getBeanDefinition();
    }
}

