/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.test.client;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.HttpComponentsClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.boot.restclient.RootUriTemplateHandler;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.NoOpResponseErrorHandler;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class TestRestTemplate {
    private final RestTemplateBuilder builder;
    private final RestTemplate restTemplate;

    public TestRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        this(restTemplateBuilder, null, null, new HttpClientOption[0]);
    }

    public TestRestTemplate(HttpClientOption ... httpClientOptions) {
        this((String)null, (String)null, httpClientOptions);
    }

    public TestRestTemplate(@Nullable String username, @Nullable String password, HttpClientOption ... httpClientOptions) {
        this(new RestTemplateBuilder(new RestTemplateCustomizer[0]), username, password, httpClientOptions);
    }

    public TestRestTemplate(RestTemplateBuilder builder, @Nullable String username, @Nullable String password, HttpClientOption ... httpClientOptions) {
        this(TestRestTemplate.createInitialBuilder(builder, username, password, httpClientOptions), null);
    }

    private TestRestTemplate(RestTemplateBuilder builder, @Nullable UriTemplateHandler uriTemplateHandler) {
        this.builder = builder;
        this.restTemplate = builder.build();
        if (uriTemplateHandler != null) {
            this.restTemplate.setUriTemplateHandler(uriTemplateHandler);
        }
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
    }

    private static RestTemplateBuilder createInitialBuilder(RestTemplateBuilder builder, @Nullable String username, @Nullable String password, HttpClientOption ... httpClientOptions) {
        Assert.notNull((Object)builder, (String)"'builder' must not be null");
        ClientHttpRequestFactoryBuilder requestFactoryBuilder = builder.requestFactoryBuilder();
        if (requestFactoryBuilder instanceof HttpComponentsClientHttpRequestFactoryBuilder) {
            builder = builder.requestFactoryBuilder((ClientHttpRequestFactoryBuilder)TestRestTemplate.applyHttpClientOptions((HttpComponentsClientHttpRequestFactoryBuilder)requestFactoryBuilder, httpClientOptions));
        }
        if (username != null && password != null) {
            builder = builder.basicAuthentication(username, password);
        }
        return builder;
    }

    private static HttpComponentsClientHttpRequestFactoryBuilder applyHttpClientOptions(HttpComponentsClientHttpRequestFactoryBuilder builder, HttpClientOption[] httpClientOptions) {
        builder = builder.withDefaultRequestConfigCustomizer((Consumer)new CookieSpecCustomizer(HttpClientOption.ENABLE_COOKIES.isPresent(httpClientOptions)));
        if (HttpClientOption.SSL.isPresent(httpClientOptions)) {
            builder = builder.withTlsSocketStrategyFactory((Function)new SelfSignedTlsSocketStrategyFactory());
        }
        return builder;
    }

    public void setUriTemplateHandler(UriTemplateHandler handler) {
        this.restTemplate.setUriTemplateHandler(handler);
    }

    public @Nullable String getRootUri() {
        UriTemplateHandler uriTemplateHandler = this.restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof RootUriTemplateHandler) {
            RootUriTemplateHandler rootHandler = (RootUriTemplateHandler)uriTemplateHandler;
            return rootHandler.getRootUri();
        }
        return "";
    }

    public <T> @Nullable T getForObject(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> @Nullable T getForObject(String url, Class<T> responseType, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> @Nullable T getForObject(URI url, Class<T> responseType) {
        return (T)this.restTemplate.getForObject(this.applyRootUriIfNecessary(url), responseType);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) {
        return this.restTemplate.getForEntity(this.applyRootUriIfNecessary(url), responseType);
    }

    public HttpHeaders headForHeaders(String url, Object ... urlVariables) {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(String url, Map<String, ?> urlVariables) {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(URI url) {
        return this.restTemplate.headForHeaders(this.applyRootUriIfNecessary(url));
    }

    public @Nullable URI postForLocation(String url, @Nullable Object request, Object ... urlVariables) {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public @Nullable URI postForLocation(String url, @Nullable Object request, Map<String, ?> urlVariables) {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public @Nullable URI postForLocation(URI url, @Nullable Object request) {
        return this.restTemplate.postForLocation(this.applyRootUriIfNecessary(url), request);
    }

    public <T> @Nullable T postForObject(String url, @Nullable Object request, Class<T> responseType, Object ... urlVariables) {
        return (T)this.restTemplate.postForObject(url, request, responseType, urlVariables);
    }

    public <T> @Nullable T postForObject(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.postForObject(url, request, responseType, urlVariables);
    }

    public <T> @Nullable T postForObject(URI url, @Nullable Object request, Class<T> responseType) {
        return (T)this.restTemplate.postForObject(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public <T> ResponseEntity<T> postForEntity(String url, @Nullable Object request, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.postForEntity(url, request, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.postForEntity(url, request, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> postForEntity(URI url, @Nullable Object request, Class<T> responseType) {
        return this.restTemplate.postForEntity(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public void put(String url, @Nullable Object request, Object ... urlVariables) {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(String url, @Nullable Object request, Map<String, ?> urlVariables) {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(URI url, @Nullable Object request) {
        this.restTemplate.put(this.applyRootUriIfNecessary(url), request);
    }

    public <T> @Nullable T patchForObject(String url, @Nullable Object request, Class<T> responseType, Object ... uriVariables) {
        return (T)this.restTemplate.patchForObject(url, request, responseType, uriVariables);
    }

    public <T> @Nullable T patchForObject(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> uriVariables) {
        return (T)this.restTemplate.patchForObject(url, request, responseType, uriVariables);
    }

    public <T> @Nullable T patchForObject(URI url, @Nullable Object request, Class<T> responseType) {
        return (T)this.restTemplate.patchForObject(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public void delete(String url, Object ... urlVariables) {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(String url, Map<String, ?> urlVariables) {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(URI url) {
        this.restTemplate.delete(this.applyRootUriIfNecessary(url));
    }

    public Set<HttpMethod> optionsForAllow(String url, Object ... urlVariables) {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> urlVariables) {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(URI url) {
        return this.restTemplate.optionsForAllow(this.applyRootUriIfNecessary(url));
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType) {
        return this.restTemplate.exchange(this.applyRootUriIfNecessary(url), method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        return this.restTemplate.exchange(this.applyRootUriIfNecessary(url), method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) {
        return this.restTemplate.exchange(this.createRequestEntityWithRootAppliedUri(requestEntity), responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        return this.restTemplate.exchange(this.createRequestEntityWithRootAppliedUri(requestEntity), responseType);
    }

    public <T> @Nullable T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Object ... urlVariables) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> @Nullable T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> @Nullable T execute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
        return (T)this.restTemplate.execute(this.applyRootUriIfNecessary(url), method, requestCallback, responseExtractor);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public TestRestTemplate withBasicAuth(@Nullable String username, @Nullable String password) {
        if (username == null || password == null) {
            return this;
        }
        return new TestRestTemplate(this.builder.basicAuthentication(username, password), this.restTemplate.getUriTemplateHandler());
    }

    public TestRestTemplate withRedirects(HttpRedirects redirects) {
        return this.withRequestFactorySettings(settings -> settings.withRedirects(redirects));
    }

    public TestRestTemplate withRequestFactorySettings(ClientHttpRequestFactorySettings requestFactorySettings) {
        return new TestRestTemplate(this.builder.requestFactorySettings(requestFactorySettings), this.restTemplate.getUriTemplateHandler());
    }

    public TestRestTemplate withRequestFactorySettings(UnaryOperator<ClientHttpRequestFactorySettings> requestFactorySettingsCustomizer) {
        return new TestRestTemplate(this.builder.requestFactorySettings(requestFactorySettingsCustomizer), this.restTemplate.getUriTemplateHandler());
    }

    private RequestEntity<?> createRequestEntityWithRootAppliedUri(RequestEntity<?> requestEntity) {
        return new RequestEntity(requestEntity.getBody(), requestEntity.getHeaders(), requestEntity.getMethod(), this.applyRootUriIfNecessary(this.resolveUri(requestEntity)), requestEntity.getType());
    }

    private URI applyRootUriIfNecessary(URI uri) {
        UriTemplateHandler uriTemplateHandler = this.restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof RootUriTemplateHandler) {
            RootUriTemplateHandler rootHandler = (RootUriTemplateHandler)uriTemplateHandler;
            if (uri.toString().startsWith("/")) {
                return URI.create(rootHandler.getRootUri() + String.valueOf(uri));
            }
        }
        return uri;
    }

    private URI resolveUri(RequestEntity<?> entity) {
        if (entity instanceof RequestEntity.UriTemplateRequestEntity) {
            RequestEntity.UriTemplateRequestEntity templatedUriEntity = (RequestEntity.UriTemplateRequestEntity)entity;
            if (templatedUriEntity.getVars() != null) {
                return this.restTemplate.getUriTemplateHandler().expand(templatedUriEntity.getUriTemplate(), templatedUriEntity.getVars());
            }
            if (templatedUriEntity.getVarsMap() != null) {
                return this.restTemplate.getUriTemplateHandler().expand(templatedUriEntity.getUriTemplate(), templatedUriEntity.getVarsMap());
            }
            throw new IllegalStateException("No variables specified for URI template: " + templatedUriEntity.getUriTemplate());
        }
        return entity.getUrl();
    }

    public static enum HttpClientOption {
        ENABLE_COOKIES,
        SSL;


        boolean isPresent(HttpClientOption[] options) {
            return ObjectUtils.containsElement((Object[])options, (Object)((Object)this));
        }
    }

    private static class CookieSpecCustomizer
    implements Consumer<RequestConfig.Builder> {
        private final boolean enableCookies;

        CookieSpecCustomizer(boolean enableCookies) {
            this.enableCookies = enableCookies;
        }

        @Override
        public void accept(RequestConfig.Builder builder) {
            builder.setCookieSpec(this.enableCookies ? "strict" : "ignore");
        }
    }

    private static final class SelfSignedTlsSocketStrategyFactory
    implements Function<SslBundle, TlsSocketStrategy> {
        private static final String[] SUPPORTED_PROTOCOLS = new String[]{TLS.V_1_3.getId(), TLS.V_1_2.getId()};

        private SelfSignedTlsSocketStrategyFactory() {
        }

        @Override
        public TlsSocketStrategy apply(@Nullable SslBundle sslBundle) {
            try {
                TrustSelfSignedStrategy trustStrategy = new TrustSelfSignedStrategy();
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)trustStrategy).build();
                return new DefaultClientTlsStrategy(sslContext, SUPPORTED_PROTOCOLS, null, null, null);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class TrustSelfSignedStrategy
    implements TrustStrategy {
        private TrustSelfSignedStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) {
            return chain.length == 1;
        }
    }
}

