/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.context;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.DynamicPropertyRegistrar;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.testcontainers.lifecycle.Startable;

class DynamicPropertySourceMethodsImporter {
    DynamicPropertySourceMethodsImporter() {
    }

    void registerDynamicPropertySources(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> definitionClass, Set<Startable> importedContainers) {
        Set methods = MethodIntrospector.selectMethods(definitionClass, this::isAnnotated);
        if (methods.isEmpty()) {
            return;
        }
        methods.forEach(this::assertValid);
        RootBeanDefinition registrarDefinition = new RootBeanDefinition();
        registrarDefinition.setBeanClass(DynamicPropertySourcePropertyRegistrar.class);
        ConstructorArgumentValues arguments = new ConstructorArgumentValues();
        arguments.addGenericArgumentValue((Object)methods);
        arguments.addGenericArgumentValue(importedContainers);
        registrarDefinition.setConstructorArgumentValues(arguments);
        beanDefinitionRegistry.registerBeanDefinition(definitionClass.getName() + ".dynamicPropertyRegistrar", (BeanDefinition)registrarDefinition);
    }

    private boolean isAnnotated(Method method) {
        return MergedAnnotations.from((AnnotatedElement)method).isPresent(DynamicPropertySource.class);
    }

    private void assertValid(Method method) {
        Assert.state((boolean)Modifier.isStatic(method.getModifiers()), () -> "@DynamicPropertySource method '" + method.getName() + "' must be static");
        Class<?>[] types = method.getParameterTypes();
        Assert.state((types.length == 1 && types[0] == DynamicPropertyRegistry.class ? 1 : 0) != 0, () -> "@DynamicPropertySource method '" + method.getName() + "' must accept a single DynamicPropertyRegistry argument");
    }

    static class DynamicPropertySourcePropertyRegistrar
    implements DynamicPropertyRegistrar {
        private final Set<Method> methods;
        private final Set<Startable> containers;

        DynamicPropertySourcePropertyRegistrar(Set<Method> methods, Set<Startable> containers) {
            this.methods = methods;
            this.containers = containers;
        }

        public void accept(DynamicPropertyRegistry registry) {
            ContainersBackedDynamicPropertyRegistry containersBackedRegistry = new ContainersBackedDynamicPropertyRegistry(registry, this.containers);
            this.methods.forEach(method -> {
                ReflectionUtils.makeAccessible((Method)method);
                ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{containersBackedRegistry});
            });
        }
    }

    static class ContainersBackedDynamicPropertyRegistry
    implements DynamicPropertyRegistry {
        private final DynamicPropertyRegistry delegate;
        private final Set<Startable> containers;

        ContainersBackedDynamicPropertyRegistry(DynamicPropertyRegistry delegate, Set<Startable> containers) {
            this.delegate = delegate;
            this.containers = containers;
        }

        public void add(String name, Supplier<Object> valueSupplier) {
            this.delegate.add(name, () -> {
                this.startContainers();
                return valueSupplier.get();
            });
        }

        private void startContainers() {
            this.containers.forEach(Startable::start);
        }
    }
}

