/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.logging.otlp.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class GrafanaOpenTelemetryLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpLoggingConnectionDetails> {
    GrafanaOpenTelemetryLoggingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingAutoConfiguration");
    }

    @Override
    protected OtlpLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new OpenTelemetryLoggingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpLoggingConnectionDetails {
        private OpenTelemetryLoggingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        public String getUrl(Transport transport) {
            String url = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Transport.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return "%s/v1/logs".formatted(url);
        }
    }
}

