/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.mongo;

import com.mongodb.ConnectionString;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MongoDBContainer;

class MongoContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MongoDBContainer, MongoConnectionDetails> {
    MongoContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "com.mongodb.ConnectionString");
    }

    @Override
    protected MongoConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MongoDBContainer> source) {
        return new MongoContainerConnectionDetails(source);
    }

    private static final class MongoContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MongoDBContainer>
    implements MongoConnectionDetails {
        private MongoContainerConnectionDetails(ContainerConnectionSource<MongoDBContainer> source) {
            super(source);
        }

        public ConnectionString getConnectionString() {
            return new ConnectionString(((MongoDBContainer)this.getContainer()).getReplicaSetUrl());
        }
    }
}

