/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.amqp;

import java.net.URI;
import java.util.List;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.RabbitMQContainer;

class RabbitContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<RabbitMQContainer, RabbitConnectionDetails> {
    RabbitContainerConnectionDetailsFactory() {
    }

    @Override
    protected RabbitConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<RabbitMQContainer> source) {
        return new RabbitMqContainerConnectionDetails(source);
    }

    private static final class RabbitMqContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<RabbitMQContainer>
    implements RabbitConnectionDetails {
        private RabbitMqContainerConnectionDetails(ContainerConnectionSource<RabbitMQContainer> source) {
            super(source);
        }

        public String getUsername() {
            return ((RabbitMQContainer)this.getContainer()).getAdminUsername();
        }

        public String getPassword() {
            return ((RabbitMQContainer)this.getContainer()).getAdminPassword();
        }

        public List<RabbitConnectionDetails.Address> getAddresses() {
            URI uri = URI.create(((RabbitMQContainer)this.getContainer()).getAmqpUrl());
            return List.of(new RabbitConnectionDetails.Address(uri.getHost(), uri.getPort()));
        }
    }
}

