/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.activemq;

import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class ActiveMQContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, ActiveMQConnectionDetails> {
    ActiveMQContainerConnectionDetailsFactory() {
        super("symptoma/activemq", new String[0]);
    }

    @Override
    protected ActiveMQConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new ActiveMQContainerConnectionDetails(source);
    }

    private static final class ActiveMQContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements ActiveMQConnectionDetails {
        private ActiveMQContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        public String getBrokerUrl() {
            return "tcp://" + this.getContainer().getHost() + ":" + this.getContainer().getFirstMappedPort();
        }

        public String getUser() {
            return (String)this.getContainer().getEnvMap().get("ACTIVEMQ_USERNAME");
        }

        public String getPassword() {
            return (String)this.getContainer().getEnvMap().get("ACTIVEMQ_PASSWORD");
        }
    }
}

