/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.properties;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.testcontainers.lifecycle.BeforeTestcontainerUsedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.util.Assert;
import org.springframework.util.function.SupplierUtils;

@Deprecated(since="3.4.0", forRemoval=true)
public class TestcontainersPropertySource
extends MapPropertySource {
    private static final Log logger = LogFactory.getLog(TestcontainersPropertySource.class);
    static final String NAME = "testcontainersPropertySource";
    private final DynamicPropertyRegistry registry;
    private final Set<ApplicationEventPublisher> eventPublishers = new CopyOnWriteArraySet<ApplicationEventPublisher>();

    TestcontainersPropertySource(DynamicPropertyRegistryInjection registryInjection) {
        this(Collections.synchronizedMap(new LinkedHashMap()), registryInjection);
    }

    private TestcontainersPropertySource(Map<String, Supplier<Object>> valueSuppliers, DynamicPropertyRegistryInjection registryInjection) {
        super(NAME, Collections.unmodifiableMap(valueSuppliers));
        this.registry = (name, valueSupplier) -> {
            Assert.hasText((String)name, (String)"'name' must not be null or blank");
            DynamicPropertyRegistryInjectionException.throwIfNecessary(name, registryInjection);
            Assert.notNull((Object)valueSupplier, (String)"'valueSupplier' must not be null");
            valueSuppliers.put(name, valueSupplier);
        };
    }

    private void addEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublishers.add(eventPublisher);
    }

    public Object getProperty(String name) {
        Object valueSupplier = ((Map)this.source).get(name);
        return valueSupplier != null ? this.getProperty(name, valueSupplier) : null;
    }

    private Object getProperty(String name, Object valueSupplier) {
        BeforeTestcontainerUsedEvent event = new BeforeTestcontainerUsedEvent((Object)this);
        this.eventPublishers.forEach(eventPublisher -> eventPublisher.publishEvent((ApplicationEvent)event));
        return SupplierUtils.resolve((Object)valueSupplier);
    }

    public static DynamicPropertyRegistry attach(Environment environment) {
        return TestcontainersPropertySource.attach(environment, null);
    }

    static DynamicPropertyRegistry attach(ConfigurableApplicationContext applicationContext) {
        return TestcontainersPropertySource.attach((Environment)applicationContext.getEnvironment(), (ApplicationEventPublisher)applicationContext, null);
    }

    public static DynamicPropertyRegistry attach(Environment environment, BeanDefinitionRegistry registry) {
        return TestcontainersPropertySource.attach(environment, null, registry);
    }

    private static DynamicPropertyRegistry attach(Environment environment, ApplicationEventPublisher eventPublisher, BeanDefinitionRegistry registry) {
        Assert.state((boolean)(environment instanceof ConfigurableEnvironment), (String)"TestcontainersPropertySource can only be attached to a ConfigurableEnvironment");
        TestcontainersPropertySource propertySource = TestcontainersPropertySource.getOrAdd((ConfigurableEnvironment)environment);
        if (eventPublisher != null) {
            propertySource.addEventPublisher(eventPublisher);
        } else if (registry != null && !registry.containsBeanDefinition(EventPublisherRegistrar.NAME)) {
            registry.registerBeanDefinition(EventPublisherRegistrar.NAME, (BeanDefinition)new RootBeanDefinition(EventPublisherRegistrar.class, () -> new EventPublisherRegistrar(environment)));
        }
        return propertySource.registry;
    }

    static TestcontainersPropertySource getOrAdd(ConfigurableEnvironment environment) {
        PropertySource propertySource = environment.getPropertySources().get(NAME);
        if (propertySource == null) {
            BindResult bindingResult = Binder.get((Environment)environment).bind("spring.testcontainers.dynamic-property-registry-injection", DynamicPropertyRegistryInjection.class);
            environment.getPropertySources().addFirst((PropertySource)new TestcontainersPropertySource((DynamicPropertyRegistryInjection)((Object)bindingResult.orElse((Object)DynamicPropertyRegistryInjection.FAIL))));
            return TestcontainersPropertySource.getOrAdd(environment);
        }
        Assert.state((boolean)(propertySource instanceof TestcontainersPropertySource), (String)"Incorrect TestcontainersPropertySource type registered");
        return (TestcontainersPropertySource)propertySource;
    }

    private static enum DynamicPropertyRegistryInjection {
        ALLOW,
        FAIL,
        WARN;

    }

    static class EventPublisherRegistrar
    implements BeanFactoryPostProcessor,
    ApplicationEventPublisherAware {
        static final String NAME = EventPublisherRegistrar.class.getName();
        private final Environment environment;
        private ApplicationEventPublisher eventPublisher;

        EventPublisherRegistrar(Environment environment) {
            this.environment = environment;
        }

        public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            if (this.eventPublisher != null) {
                TestcontainersPropertySource.getOrAdd((ConfigurableEnvironment)this.environment).addEventPublisher(this.eventPublisher);
            }
        }
    }

    static final class DynamicPropertyRegistryInjectionException
    extends RuntimeException {
        private DynamicPropertyRegistryInjectionException(String propertyName) {
            super("Support for injecting a DynamicPropertyRegistry into @Bean methods is deprecated. Register '" + propertyName + "' using a DynamicPropertyRegistrar bean instead. Alternatively, set spring.testcontainers.dynamic-property-registry-injection to 'warn' to replace this failure with a warning or to 'allow' to permit injection of the registry.");
        }

        private static void throwIfNecessary(String propertyName, DynamicPropertyRegistryInjection registryInjection) {
            switch (registryInjection) {
                case FAIL: {
                    throw new DynamicPropertyRegistryInjectionException(propertyName);
                }
                case WARN: {
                    logger.warn((Object)("Support for injecting a DynamicPropertyRegistry into @Bean methods is deprecated. Register '" + propertyName + "' using a DynamicPropertyRegistrar bean instead."));
                }
            }
        }
    }
}

