/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.List;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;
import org.mockito.mock.MockCreationSettings;
import org.springframework.boot.test.mock.mockito.MockitoApi;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum MockReset {
    BEFORE,
    AFTER,
    NONE;

    private static final boolean MOCKITO_PRESENT;

    public static MockSettings before() {
        return MockReset.withSettings(BEFORE);
    }

    public static MockSettings after() {
        return MockReset.withSettings(AFTER);
    }

    public static MockSettings withSettings(MockReset reset) {
        return MockReset.apply(reset, Mockito.withSettings());
    }

    public static MockSettings apply(MockReset reset, MockSettings settings) {
        Assert.notNull((Object)settings, (String)"Settings must not be null");
        if (reset != null && reset != NONE) {
            settings.invocationListeners(new InvocationListener[]{new ResetInvocationListener(reset)});
        }
        return settings;
    }

    static MockReset get(Object mock) {
        MockReset reset = NONE;
        if (MOCKITO_PRESENT && Mockito.mockingDetails((Object)mock).isMock()) {
            MockCreationSettings<?> settings = MockitoApi.get().getMockSettings(mock);
            List listeners = settings.getInvocationListeners();
            for (Object listener : listeners) {
                if (!(listener instanceof ResetInvocationListener)) continue;
                reset = ((ResetInvocationListener)listener).getReset();
            }
        }
        return reset;
    }

    static {
        MOCKITO_PRESENT = ClassUtils.isPresent((String)"org.mockito.internal.util.MockUtil", null);
    }

    private static class ResetInvocationListener
    implements InvocationListener {
        private final MockReset reset;

        ResetInvocationListener(MockReset reset) {
            this.reset = reset;
        }

        public MockReset getReset() {
            return this.reset;
        }

        public void reportInvocation(MethodInvocationReport methodInvocationReport) {
        }
    }
}

