/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockitoPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class MockitoTestExecutionListener
extends AbstractTestExecutionListener {
    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (this.hasMockitoAnnotations(testContext)) {
            MockitoAnnotations.initMocks((Object)testContext.getTestInstance());
        }
        this.injectFields(testContext);
    }

    private boolean hasMockitoAnnotations(TestContext testContext) {
        MockitoAnnotationCollection collector = new MockitoAnnotationCollection();
        ReflectionUtils.doWithFields((Class)testContext.getTestClass(), (ReflectionUtils.FieldCallback)collector);
        return collector.hasAnnotations();
    }

    private void injectFields(TestContext testContext) {
        DefinitionsParser parser = new DefinitionsParser();
        parser.parse(testContext.getTestClass());
        if (!parser.getDefinitions().isEmpty()) {
            this.injectFields(testContext, parser);
        }
    }

    private void injectFields(TestContext testContext, DefinitionsParser parser) {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        MockitoPostProcessor postProcessor = (MockitoPostProcessor)((Object)applicationContext.getBean(MockitoPostProcessor.class));
        for (Definition definition : parser.getDefinitions()) {
            Field field = parser.getField(definition);
            if (field == null) continue;
            postProcessor.inject(field, testContext.getTestInstance(), definition);
        }
    }

    private static class MockitoAnnotationCollection
    implements ReflectionUtils.FieldCallback {
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

        private MockitoAnnotationCollection() {
        }

        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith("org.mockito")) continue;
                this.annotations.add(annotation);
            }
        }

        public boolean hasAnnotations() {
            return !this.annotations.isEmpty();
        }
    }
}

