/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.graphql.tester;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.test.autoconfigure.web.reactive.WebTestClientAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.test.tester.HttpGraphQlTester;
import org.springframework.graphql.test.tester.WebGraphQlTester;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={WebTestClientAutoConfiguration.class, MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={WebClient.class, WebTestClient.class, WebGraphQlTester.class})
public class HttpGraphQlTesterAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={WebTestClient.class})
    @ConditionalOnMissingBean
    public HttpGraphQlTester webTestClientGraphQlTester(WebTestClient webTestClient, GraphQlProperties properties) {
        WebTestClient mutatedWebTestClient = webTestClient.mutate().baseUrl(properties.getHttp().getPath()).build();
        return HttpGraphQlTester.create((WebTestClient)mutatedWebTestClient);
    }
}

