/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.autoconfigure.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.neo4j.driver.Config;
import org.neo4j.driver.observation.ObservationProvider;
import org.neo4j.driver.observation.micrometer.MicrometerObservationProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.neo4j.autoconfigure.ConfigBuilderCustomizer;
import org.springframework.boot.neo4j.autoconfigure.Neo4jAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration(before={Neo4jAutoConfiguration.class}, afterName={"org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnBean(value={ObservationRegistry.class})
@ConditionalOnClass(value={Config.ConfigBuilder.class, MicrometerObservationProvider.class, Observation.class})
public final class Neo4jObservationAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={ObservationRegistry.class})
    @Order(value=0)
    ConfigBuilderCustomizer neo4jObservationCustomizer(ObservationRegistry registry) {
        return builder -> builder.withObservationProvider((ObservationProvider)MicrometerObservationProvider.builder((ObservationRegistry)registry).build());
    }
}

