/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.loader.tools.DefaultLibraryCoordinates;

public interface LibraryCoordinates {
    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public static LibraryCoordinates of(String groupId, String artifactId, String version) {
        return new DefaultLibraryCoordinates(groupId, artifactId, version);
    }

    public static String toStandardNotationString(@Nullable LibraryCoordinates coordinates) {
        if (coordinates == null) {
            return "::";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(coordinates.getGroupId() != null ? coordinates.getGroupId() : "");
        builder.append(":");
        builder.append(coordinates.getArtifactId() != null ? coordinates.getArtifactId() : "");
        builder.append(":");
        builder.append(coordinates.getVersion() != null ? coordinates.getVersion() : "");
        return builder.toString();
    }
}

