/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.legacy.context.web;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.legacy.context.web.AnnotationConfigNonEmbeddedWebApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.StandardServletEnvironment;

public class SpringBootContextLoaderListener
extends ContextLoaderListener {
    private static final Log logger = LogFactory.getLog(SpringBootContextLoaderListener.class);
    private static final String INIT_PARAM_DELIMITERS = ",; \t\n";

    public WebApplicationContext initWebApplicationContext(final ServletContext servletContext) {
        WebApplicationContext context;
        String configLocationParam = servletContext.getInitParameter("contextConfigLocation");
        String[] classNames = StringUtils.tokenizeToStringArray((String)configLocationParam, (String)INIT_PARAM_DELIMITERS);
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classes.length; ++i) {
            try {
                classes[i] = ClassUtils.forName((String)classNames[i], null);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ApplicationContextException("Failed to load custom context class [" + classNames[i] + "]", (Throwable)e);
            }
        }
        SpringApplicationBuilder builder = new SpringApplicationBuilder(classes);
        StandardServletEnvironment environment = new StandardServletEnvironment();
        environment.initPropertySources(servletContext, (ServletConfig)null);
        builder.environment((ConfigurableEnvironment)environment);
        Class<?> contextClass = this.determineContextClass(servletContext);
        builder.contextClass(contextClass);
        ApplicationContext parent = this.getExistingRootWebApplicationContext(servletContext);
        if (parent != null) {
            logger.info((Object)"Root context already created (using as parent).");
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, null);
            builder.initializers(new ApplicationContextInitializer[]{new ParentContextApplicationContextInitializer(parent)});
            context = (WebApplicationContext)builder.run(new String[0]);
        } else {
            logger.info((Object)"No existing root context; will created one.");
            builder.initializers(new ApplicationContextInitializer[]{new ApplicationContextInitializer<GenericWebApplicationContext>(){

                public void initialize(GenericWebApplicationContext applicationContext) {
                    applicationContext.setServletContext(servletContext);
                }
            }});
            context = (WebApplicationContext)builder.run(new String[0]);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        }
        return context;
    }

    private ApplicationContext getExistingRootWebApplicationContext(ServletContext servletContext) {
        Object context = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (context instanceof ApplicationContext) {
            return (ApplicationContext)context;
        }
        return null;
    }

    protected Class<?> determineContextClass(ServletContext servletContext) {
        String contextClassName = servletContext.getInitParameter("contextClass");
        if (contextClassName != null) {
            try {
                return ClassUtils.forName((String)contextClassName, null);
            }
            catch (Exception e) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)e);
            }
        }
        return AnnotationConfigNonEmbeddedWebApplicationContext.class;
    }
}

