/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.legacy.context.web;

import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.servlet.LegacyServletContextInitializerBeans;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NonEmbeddedWebApplicationContext
extends GenericWebApplicationContext {
    private ServletConfig servletConfig;
    private String namespace;

    public NonEmbeddedWebApplicationContext() {
    }

    public NonEmbeddedWebApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    protected void onRefresh() {
        super.onRefresh();
        try {
            this.init();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start application context", ex);
        }
    }

    public void init() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            try {
                this.getSelfInitializer().onStartup(servletContext);
            }
            catch (ServletException ex) {
                throw new ApplicationContextException("Cannot initialize servlet context", (Throwable)ex);
            }
        }
        this.initPropertySources();
    }

    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    private ServletContextInitializer getSelfInitializer() {
        return this::selfInitialize;
    }

    private void selfInitialize(ServletContext servletContext) throws ServletException {
        this.prepareWebApplicationContext(servletContext);
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        ServletWebServerApplicationContext.ExistingWebApplicationScopes existingScopes = new ServletWebServerApplicationContext.ExistingWebApplicationScopes(beanFactory);
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)beanFactory, (ServletContext)this.getServletContext());
        existingScopes.restore();
        WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)beanFactory, (ServletContext)this.getServletContext());
        Collection<ServletContextInitializer> servletContextInitializerBeans = servletContext.getMajorVersion() >= 3 ? this.getServletContextInitializerBeans() : this.getLegacyServletContextInitializerBeans();
        for (ServletContextInitializer beans : servletContextInitializerBeans) {
            beans.onStartup(servletContext);
        }
    }

    protected Collection<ServletContextInitializer> getServletContextInitializerBeans() {
        return new ServletContextInitializerBeans((ListableBeanFactory)this.getBeanFactory());
    }

    protected Collection<ServletContextInitializer> getLegacyServletContextInitializerBeans() {
        return new LegacyServletContextInitializerBeans((ListableBeanFactory)this.getBeanFactory());
    }

    protected void prepareWebApplicationContext(ServletContext servletContext) {
        Object rootContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (rootContext != null) {
            if (rootContext == this) {
                throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ServletContextInitializers!");
            }
            return;
        }
        Log logger = LogFactory.getLog(ContextLoader.class);
        servletContext.log("Initializing Spring Boot Legacy WebApplicationContext");
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)this.getBeanFactory(), (ServletContext)this.getServletContext());
        WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)this.getBeanFactory(), (ServletContext)this.getServletContext());
        try {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            this.setServletContext(servletContext);
            if (logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - this.getStartupDate();
                logger.info((Object)("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
    }

    protected Resource getResourceByPath(String path) {
        if (this.getServletContext() == null) {
            return new DefaultResourceLoader.ClassPathContextResource(path, this.getClassLoader());
        }
        return new ServletContextResource(this.getServletContext(), path);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }
}

