/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure.health;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.redis.autoconfigure.DataRedisReactiveAutoConfiguration;
import org.springframework.boot.data.redis.health.DataRedisReactiveHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={DataRedisReactiveAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, Flux.class, ReactiveHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={ReactiveRedisConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="redis")
public final class DataRedisReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<DataRedisReactiveHealthIndicator, ReactiveRedisConnectionFactory> {
    DataRedisReactiveHealthContributorAutoConfiguration() {
        super(DataRedisReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisHealthIndicator", "redisHealthContributor"})
    ReactiveHealthContributor redisHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, ReactiveRedisConnectionFactory.class);
    }
}

