/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class ConventionUtils {
    private static final Set<Character> SEPARATORS;

    public static String toDashedCase(String value) {
        StringBuilder dashed = new StringBuilder();
        Character previous = null;
        for (int i = 0; i < value.length(); ++i) {
            char current = value.charAt(i);
            if (SEPARATORS.contains(Character.valueOf(current))) {
                dashed.append("-");
            } else if (Character.isUpperCase(current) && previous != null && !SEPARATORS.contains(previous)) {
                dashed.append("-").append(current);
            } else {
                dashed.append(current);
            }
            previous = Character.valueOf(current);
        }
        return dashed.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        List<Character> chars = Arrays.asList(Character.valueOf('-'), Character.valueOf('_'));
        SEPARATORS = Collections.unmodifiableSet(new HashSet<Character>(chars));
    }
}

