/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.configuration.Credential;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;

class CredentialHelper {
    private static final String USR_LOCAL_BIN = "/usr/local/bin/";
    private static final Set<String> CREDENTIAL_NOT_FOUND_MESSAGES = Set.of("credentials not found in native keychain", "no credentials server URL", "no credentials username");
    private final String executable;

    CredentialHelper(String executable) {
        this.executable = executable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable Credential get(String serverUrl) throws IOException {
        ProcessBuilder processBuilder = this.processBuilder("get");
        Process process = this.start(processBuilder);
        try (OutputStream request = process.getOutputStream();){
            request.write(serverUrl.getBytes(StandardCharsets.UTF_8));
        }
        try {
            int exitCode = process.waitFor();
            try (InputStream response = process.getInputStream();){
                if (exitCode == 0) {
                    Credential credential2 = new Credential(SharedObjectMapper.get().readTree(response));
                    return credential2;
                }
                String errorMessage = new String(response.readAllBytes(), StandardCharsets.UTF_8);
                if (!CredentialHelper.isCredentialsNotFoundError(errorMessage)) {
                    throw new IOException("%s' exited with code %d: %s".formatted(process, exitCode, errorMessage));
                }
                Credential credential = null;
                return credential;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private ProcessBuilder processBuilder(String action) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).redirectErrorStream(true);
        if (Platform.isWindows()) {
            processBuilder.command("cmd", "/c");
        }
        processBuilder.command(this.executable, action);
        return processBuilder;
    }

    private Process start(ProcessBuilder processBuilder) throws IOException {
        try {
            return processBuilder.start();
        }
        catch (IOException ex) {
            if (!Platform.isMac()) {
                throw ex;
            }
            try {
                ArrayList<String> command = new ArrayList<String>(processBuilder.command());
                command.set(0, USR_LOCAL_BIN + (String)command.get(0));
                return processBuilder.command(command).start();
            }
            catch (Exception suppressed) {
                ex.addSuppressed(suppressed);
                throw ex;
            }
        }
    }

    private static boolean isCredentialsNotFoundError(String message) {
        return CREDENTIAL_NOT_FOUND_MESSAGES.contains(message.trim());
    }
}

