/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import com.sun.jna.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfigurationMetadata;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerHost;
import org.springframework.boot.buildpack.platform.system.Environment;

public class ResolvedDockerHost
extends DockerHost {
    private static final String UNIX_SOCKET_PREFIX = "unix://";
    private static final String DOMAIN_SOCKET_PATH = "/var/run/docker.sock";
    private static final String WINDOWS_NAMED_PIPE_PATH = "//./pipe/docker_engine";
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    private static final String DOCKER_CONTEXT = "DOCKER_CONTEXT";

    ResolvedDockerHost(String address) {
        super(address);
    }

    ResolvedDockerHost(String address, boolean secure, String certificatePath) {
        super(address, secure, certificatePath);
    }

    @Override
    public String getAddress() {
        String address = super.getAddress();
        if (address == null) {
            address = ResolvedDockerHost.getDefaultAddress();
        }
        return address.startsWith(UNIX_SOCKET_PREFIX) ? address.substring(UNIX_SOCKET_PREFIX.length()) : address;
    }

    public boolean isRemote() {
        return this.getAddress().startsWith("http") || this.getAddress().startsWith("tcp");
    }

    public boolean isLocalFileReference() {
        try {
            return Files.exists(Paths.get(this.getAddress(), new String[0]), new LinkOption[0]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ResolvedDockerHost from(DockerConfiguration.DockerHostConfiguration dockerHost) {
        return ResolvedDockerHost.from(Environment.SYSTEM, dockerHost);
    }

    static ResolvedDockerHost from(Environment environment, DockerConfiguration.DockerHostConfiguration dockerHost) {
        DockerConfigurationMetadata config = DockerConfigurationMetadata.from(environment);
        if (environment.get(DOCKER_CONTEXT) != null) {
            DockerConfigurationMetadata.DockerContext context = config.forContext(environment.get(DOCKER_CONTEXT));
            return new ResolvedDockerHost(context.getDockerHost(), context.isTlsVerify(), context.getTlsPath());
        }
        if (dockerHost != null && dockerHost.getContext() != null) {
            DockerConfigurationMetadata.DockerContext context = config.forContext(dockerHost.getContext());
            return new ResolvedDockerHost(context.getDockerHost(), context.isTlsVerify(), context.getTlsPath());
        }
        if (environment.get(DOCKER_HOST) != null) {
            return new ResolvedDockerHost(environment.get(DOCKER_HOST), ResolvedDockerHost.isTrue(environment.get(DOCKER_TLS_VERIFY)), environment.get(DOCKER_CERT_PATH));
        }
        if (dockerHost != null && dockerHost.getAddress() != null) {
            return new ResolvedDockerHost(dockerHost.getAddress(), dockerHost.isSecure(), dockerHost.getCertificatePath());
        }
        if (config.getContext().getDockerHost() != null) {
            DockerConfigurationMetadata.DockerContext context = config.getContext();
            return new ResolvedDockerHost(context.getDockerHost(), context.isTlsVerify(), context.getTlsPath());
        }
        return new ResolvedDockerHost(ResolvedDockerHost.getDefaultAddress());
    }

    private static String getDefaultAddress() {
        return Platform.isWindows() ? WINDOWS_NAMED_PIPE_PATH : DOMAIN_SOCKET_PATH;
    }

    private static boolean isTrue(String value) {
        try {
            return value != null && Integer.parseInt(value) == 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

