/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;

class AutoConfigurationSorter {
    private final MetadataReaderFactory metadataReaderFactory;
    private final @Nullable AutoConfigurationMetadata autoConfigurationMetadata;
    private final @Nullable UnaryOperator<String> replacementMapper;

    AutoConfigurationSorter(MetadataReaderFactory metadataReaderFactory, @Nullable AutoConfigurationMetadata autoConfigurationMetadata, @Nullable UnaryOperator<String> replacementMapper) {
        Assert.notNull((Object)metadataReaderFactory, (String)"'metadataReaderFactory' must not be null");
        this.metadataReaderFactory = metadataReaderFactory;
        this.autoConfigurationMetadata = autoConfigurationMetadata;
        this.replacementMapper = replacementMapper;
    }

    List<String> getInPriorityOrder(Collection<String> classNames) {
        ArrayList<String> alphabeticallyOrderedClassNames = new ArrayList<String>(classNames);
        Collections.sort(alphabeticallyOrderedClassNames);
        AutoConfigurationClasses classes = new AutoConfigurationClasses(this.metadataReaderFactory, this.autoConfigurationMetadata, alphabeticallyOrderedClassNames);
        List<String> orderedClassNames = new ArrayList<String>(classNames);
        Collections.sort(orderedClassNames);
        orderedClassNames.sort((o1, o2) -> {
            int i1 = classes.get((String)o1).getOrder();
            int i2 = classes.get((String)o2).getOrder();
            return Integer.compare(i1, i2);
        });
        orderedClassNames = this.sortByAnnotation(classes, orderedClassNames);
        return orderedClassNames;
    }

    private List<String> sortByAnnotation(AutoConfigurationClasses classes, List<String> classNames) {
        ArrayList<String> toSort = new ArrayList<String>(classNames);
        toSort.addAll(classes.getAllNames());
        LinkedHashSet<String> sorted = new LinkedHashSet<String>();
        LinkedHashSet<String> processing = new LinkedHashSet<String>();
        while (!toSort.isEmpty()) {
            this.doSortByAfterAnnotation(classes, toSort, sorted, processing, null);
        }
        sorted.retainAll(classNames);
        return new ArrayList<String>(sorted);
    }

    private void doSortByAfterAnnotation(AutoConfigurationClasses classes, List<String> toSort, Set<String> sorted, Set<String> processing, @Nullable String current) {
        if (current == null) {
            current = toSort.remove(0);
        }
        processing.add(current);
        TreeSet<String> afters = new TreeSet<String>(Comparator.comparing(toSort::indexOf));
        afters.addAll(classes.getClassesRequestedAfter(current));
        for (String after : afters) {
            this.checkForCycles(processing, current, after);
            if (sorted.contains(after) || !toSort.contains(after)) continue;
            this.doSortByAfterAnnotation(classes, toSort, sorted, processing, after);
        }
        processing.remove(current);
        sorted.add(current);
    }

    private void checkForCycles(Set<String> processing, String current, String after) {
        Assert.state((!processing.contains(after) ? 1 : 0) != 0, () -> "AutoConfigure cycle detected between " + current + " and " + after);
    }

    private class AutoConfigurationClasses {
        private final Map<String, AutoConfigurationClass> classes = new LinkedHashMap<String, AutoConfigurationClass>();

        AutoConfigurationClasses(@Nullable MetadataReaderFactory metadataReaderFactory, AutoConfigurationMetadata autoConfigurationMetadata, Collection<String> classNames) {
            this.addToClasses(metadataReaderFactory, autoConfigurationMetadata, classNames, true);
        }

        Set<String> getAllNames() {
            return this.classes.keySet();
        }

        private void addToClasses(MetadataReaderFactory metadataReaderFactory, @Nullable AutoConfigurationMetadata autoConfigurationMetadata, Collection<String> classNames, boolean required) {
            for (String className : classNames) {
                if (this.classes.containsKey(className)) continue;
                AutoConfigurationClass autoConfigurationClass = new AutoConfigurationClass(className, metadataReaderFactory, autoConfigurationMetadata);
                boolean available = autoConfigurationClass.isAvailable();
                if (required || available) {
                    this.classes.put(className, autoConfigurationClass);
                }
                if (!available) continue;
                this.addToClasses(metadataReaderFactory, autoConfigurationMetadata, autoConfigurationClass.getBefore(), false);
                this.addToClasses(metadataReaderFactory, autoConfigurationMetadata, autoConfigurationClass.getAfter(), false);
            }
        }

        AutoConfigurationClass get(String className) {
            AutoConfigurationClass autoConfigurationClass = this.classes.get(className);
            Assert.state((autoConfigurationClass != null ? 1 : 0) != 0, (String)"'autoConfigurationClass' must not be null");
            return autoConfigurationClass;
        }

        Set<String> getClassesRequestedAfter(String className) {
            LinkedHashSet<String> classesRequestedAfter = new LinkedHashSet<String>(this.get(className).getAfter());
            this.classes.forEach((name, autoConfigurationClass) -> {
                if (autoConfigurationClass.getBefore().contains(className)) {
                    classesRequestedAfter.add((String)name);
                }
            });
            return classesRequestedAfter;
        }
    }

    private class AutoConfigurationClass {
        private final String className;
        private final MetadataReaderFactory metadataReaderFactory;
        private final @Nullable AutoConfigurationMetadata autoConfigurationMetadata;
        private volatile @Nullable AnnotationMetadata annotationMetadata;
        private volatile @Nullable Set<String> before;
        private volatile @Nullable Set<String> after;

        AutoConfigurationClass(String className, @Nullable MetadataReaderFactory metadataReaderFactory, AutoConfigurationMetadata autoConfigurationMetadata) {
            this.className = className;
            this.metadataReaderFactory = metadataReaderFactory;
            this.autoConfigurationMetadata = autoConfigurationMetadata;
        }

        boolean isAvailable() {
            try {
                if (!this.wasProcessed()) {
                    this.getAnnotationMetadata();
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        Set<String> getBefore() {
            Set<String> before = this.before;
            if (before == null) {
                this.before = before = this.getClassNames("AutoConfigureBefore", AutoConfigureBefore.class);
            }
            return before;
        }

        Set<String> getAfter() {
            Set<String> after = this.after;
            if (after == null) {
                this.after = after = this.getClassNames("AutoConfigureAfter", AutoConfigureAfter.class);
            }
            return after;
        }

        private Set<String> getClassNames(String metadataKey, Class<? extends Annotation> annotation) {
            Set<String> annotationValue = this.wasProcessed() ? this.getSet(metadataKey) : this.getAnnotationValue(annotation);
            return this.applyReplacements(annotationValue);
        }

        private Set<String> getSet(String metadataKey) {
            Assert.state((this.autoConfigurationMetadata != null ? 1 : 0) != 0, (String)"'autoConfigurationMetadata' must not be null");
            return this.autoConfigurationMetadata.getSet(this.className, metadataKey, Collections.emptySet());
        }

        private Set<String> applyReplacements(Set<String> values) {
            if (AutoConfigurationSorter.this.replacementMapper == null) {
                return values;
            }
            LinkedHashSet<String> replaced = new LinkedHashSet<String>(values);
            for (String value : values) {
                replaced.add((String)AutoConfigurationSorter.this.replacementMapper.apply(value));
            }
            return replaced;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private int getOrder() {
            if (this.wasProcessed()) {
                Assert.state((this.autoConfigurationMetadata != null ? 1 : 0) != 0, (String)"'autoConfigurationMetadata' must not be null");
                return this.autoConfigurationMetadata.getInteger(this.className, "AutoConfigureOrder", 0);
            }
            @Nullable Map attributes = this.getAnnotationMetadata().getAnnotationAttributes(AutoConfigureOrder.class.getName());
            if (attributes != null) {
                Integer value = (Integer)attributes.get("value");
                Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
                return value;
            }
            return 0;
        }

        private boolean wasProcessed() {
            return this.autoConfigurationMetadata != null && this.autoConfigurationMetadata.wasProcessed(this.className);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private Set<String> getAnnotationValue(Class<?> annotation) {
            @Nullable Map attributes = this.getAnnotationMetadata().getAnnotationAttributes(annotation.getName(), true);
            if (attributes == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            String[] value = (String[])attributes.get("value");
            String[] name = (String[])attributes.get("name");
            Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
            Assert.state((name != null ? 1 : 0) != 0, (String)"'name' must not be null");
            Collections.addAll(result, value);
            Collections.addAll(result, name);
            return result;
        }

        private AnnotationMetadata getAnnotationMetadata() {
            AnnotationMetadata annotationMetadata = this.annotationMetadata;
            if (annotationMetadata == null) {
                try {
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(this.className);
                    this.annotationMetadata = annotationMetadata = metadataReader.getAnnotationMetadata();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Unable to read meta-data for class " + this.className, ex);
                }
            }
            return annotationMetadata;
        }
    }
}

