/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public abstract class MongoClientFactorySupport<T> {
    private final MongoProperties properties;
    private final Environment environment;
    private final List<MongoClientSettingsBuilderCustomizer> builderCustomizers;
    private final BiFunction<MongoClientSettings, MongoDriverInformation, T> clientCreator;

    protected MongoClientFactorySupport(MongoProperties properties, Environment environment, List<MongoClientSettingsBuilderCustomizer> builderCustomizers, BiFunction<MongoClientSettings, MongoDriverInformation, T> clientCreator) {
        this.properties = properties;
        this.environment = environment;
        this.builderCustomizers = builderCustomizers != null ? builderCustomizers : Collections.emptyList();
        this.clientCreator = clientCreator;
    }

    public T createMongoClient(MongoClientSettings settings) {
        MongoClientSettings targetSettings = this.computeClientSettings(settings);
        return this.clientCreator.apply(targetSettings, this.driverInformation());
    }

    private MongoClientSettings computeClientSettings(MongoClientSettings settings) {
        MongoClientSettings.Builder settingsBuilder = settings != null ? MongoClientSettings.builder((MongoClientSettings)settings) : MongoClientSettings.builder();
        this.validateConfiguration();
        this.applyUuidRepresentation(settingsBuilder);
        this.applyHostAndPort(settingsBuilder);
        this.applyCredentials(settingsBuilder);
        this.applyReplicaSet(settingsBuilder);
        this.customize(settingsBuilder);
        return settingsBuilder.build();
    }

    private void validateConfiguration() {
        if (this.hasCustomAddress() || this.hasCustomCredentials() || this.hasReplicaSet()) {
            Assert.state((this.properties.getUri() == null ? 1 : 0) != 0, (String)"Invalid mongo configuration, either uri or host/port/credentials/replicaSet must be specified");
        }
    }

    private void applyUuidRepresentation(MongoClientSettings.Builder settingsBuilder) {
        settingsBuilder.uuidRepresentation(this.properties.getUuidRepresentation());
    }

    private void applyHostAndPort(MongoClientSettings.Builder settings) {
        if (this.isEmbedded()) {
            settings.applyConnectionString(new ConnectionString("mongodb://localhost:" + this.getEmbeddedPort()));
            return;
        }
        if (this.hasCustomAddress()) {
            String host = this.getOrDefault(this.properties.getHost(), "localhost");
            int port = this.getOrDefault(this.properties.getPort(), 27017);
            ServerAddress serverAddress = new ServerAddress(host, port);
            settings.applyToClusterSettings(cluster -> cluster.hosts(Collections.singletonList(serverAddress)));
            return;
        }
        settings.applyConnectionString(new ConnectionString(this.properties.determineUri()));
    }

    private void applyCredentials(MongoClientSettings.Builder builder) {
        if (this.hasCustomCredentials()) {
            String database = this.properties.getAuthenticationDatabase() != null ? this.properties.getAuthenticationDatabase() : this.properties.getMongoClientDatabase();
            builder.credential(MongoCredential.createCredential((String)this.properties.getUsername(), (String)database, (char[])this.properties.getPassword()));
        }
    }

    private void applyReplicaSet(MongoClientSettings.Builder builder) {
        if (this.hasReplicaSet()) {
            builder.applyToClusterSettings(cluster -> cluster.requiredReplicaSetName(this.properties.getReplicaSetName()));
        }
    }

    private void customize(MongoClientSettings.Builder builder) {
        for (MongoClientSettingsBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
    }

    private <V> V getOrDefault(V value, V defaultValue) {
        return value != null ? value : defaultValue;
    }

    private Integer getEmbeddedPort() {
        String localPort;
        if (this.environment != null && (localPort = this.environment.getProperty("local.mongo.port")) != null) {
            return Integer.valueOf(localPort);
        }
        return null;
    }

    private boolean isEmbedded() {
        return this.getEmbeddedPort() != null;
    }

    private boolean hasCustomCredentials() {
        return this.properties.getUsername() != null && this.properties.getPassword() != null;
    }

    private boolean hasReplicaSet() {
        return this.properties.getReplicaSetName() != null;
    }

    private boolean hasCustomAddress() {
        return this.properties.getHost() != null || this.properties.getPort() != null;
    }

    private MongoDriverInformation driverInformation() {
        return MongoDriverInformation.builder((MongoDriverInformation)MongoDriverInformation.builder().build()).driverName("spring-boot").build();
    }
}

