/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="spring.data.mongodb")
public class MongoProperties {
    public static final int DEFAULT_PORT = 27017;
    public static final String DEFAULT_URI = "mongodb://localhost/test";
    private String host;
    private Integer port = null;
    private String uri;
    private String database;
    private String authenticationDatabase;
    private String gridFsDatabase;
    private String username;
    private char[] password;
    private Class<?> fieldNamingStrategy;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getAuthenticationDatabase() {
        return this.authenticationDatabase;
    }

    public void setAuthenticationDatabase(String authenticationDatabase) {
        this.authenticationDatabase = authenticationDatabase;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public Class<?> getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public void setFieldNamingStrategy(Class<?> fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    public void clearPassword() {
        if (this.password == null) {
            return;
        }
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String determineUri() {
        return this.uri != null ? this.uri : DEFAULT_URI;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getGridFsDatabase() {
        return this.gridFsDatabase;
    }

    public void setGridFsDatabase(String gridFsDatabase) {
        this.gridFsDatabase = gridFsDatabase;
    }

    public String getMongoClientDatabase() {
        if (this.database != null) {
            return this.database;
        }
        return new MongoClientURI(this.determineUri()).getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoClient createMongoClient(MongoClientOptions options, Environment environment) throws UnknownHostException {
        try {
            if (this.hasCustomAddress() || this.hasCustomCredentials()) {
                if (this.uri != null) {
                    throw new IllegalStateException("Invalid mongo configuration, either uri or host/port/credentials must be specified");
                }
                if (options == null) {
                    options = MongoClientOptions.builder().build();
                }
                ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
                if (this.hasCustomCredentials()) {
                    String database = this.authenticationDatabase == null ? this.getMongoClientDatabase() : this.authenticationDatabase;
                    credentials.add(MongoCredential.createCredential((String)this.username, (String)database, (char[])this.password));
                }
                String host = this.host == null ? "localhost" : this.host;
                int port = this.determinePort(environment);
                MongoClient mongoClient = new MongoClient(Collections.singletonList(new ServerAddress(host, port)), credentials, options);
                return mongoClient;
            }
            MongoClient mongoClient = new MongoClient(new MongoClientURI(this.determineUri(), this.builder(options)));
            return mongoClient;
        }
        finally {
            this.clearPassword();
        }
    }

    private boolean hasCustomAddress() {
        return this.host != null || this.port != null;
    }

    private boolean hasCustomCredentials() {
        return this.username != null && this.password != null;
    }

    private int determinePort(Environment environment) {
        if (this.port == null) {
            return 27017;
        }
        if (this.port == 0) {
            String localPort;
            if (environment != null && (localPort = environment.getProperty("local.mongo.port")) != null) {
                return Integer.valueOf(localPort);
            }
            throw new IllegalStateException("spring.data.mongodb.port=0 and no local mongo port configuration is available");
        }
        return this.port;
    }

    private MongoClientOptions.Builder builder(MongoClientOptions options) {
        if (options != null) {
            return MongoClientOptions.builder((MongoClientOptions)options);
        }
        return MongoClientOptions.builder();
    }
}

